/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Consumer;
import com.snowplowanalytics.snowplow.configuration.Configuration;
import com.snowplowanalytics.snowplow.configuration.EmitterConfiguration;
import com.snowplowanalytics.snowplow.configuration.GdprConfiguration;
import com.snowplowanalytics.snowplow.configuration.GlobalContextsConfiguration;
import com.snowplowanalytics.snowplow.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.configuration.SessionConfiguration;
import com.snowplowanalytics.snowplow.configuration.SubjectConfiguration;
import com.snowplowanalytics.snowplow.configuration.TrackerConfiguration;
import com.snowplowanalytics.snowplow.internal.emitter.Emitter;
import com.snowplowanalytics.snowplow.internal.emitter.EmitterConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.emitter.EmitterControllerImpl;
import com.snowplowanalytics.snowplow.internal.emitter.NetworkConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.emitter.NetworkControllerImpl;
import com.snowplowanalytics.snowplow.internal.gdpr.Gdpr;
import com.snowplowanalytics.snowplow.internal.gdpr.GdprConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.gdpr.GdprControllerImpl;
import com.snowplowanalytics.snowplow.internal.globalcontexts.GlobalContextsControllerImpl;
import com.snowplowanalytics.snowplow.internal.session.Session;
import com.snowplowanalytics.snowplow.internal.session.SessionConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.session.SessionControllerImpl;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProviderInterface;
import com.snowplowanalytics.snowplow.internal.tracker.Subject;
import com.snowplowanalytics.snowplow.internal.tracker.SubjectConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.tracker.SubjectControllerImpl;
import com.snowplowanalytics.snowplow.internal.tracker.Tracker;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerConfigurationUpdate;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerControllerImpl;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.Protocol;
import com.snowplowanalytics.snowplow.tracker.SessionState;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ServiceProvider
implements ServiceProviderInterface {
    @NonNull
    private final Context context;
    @NonNull
    private final String namespace;
    @NonNull
    private final String appId;
    @Nullable
    private Tracker tracker;
    @Nullable
    private Emitter emitter;
    @Nullable
    private Subject subject;
    @Nullable
    private TrackerControllerImpl trackerController;
    @Nullable
    private EmitterControllerImpl emitterController;
    @Nullable
    private NetworkControllerImpl networkController;
    @Nullable
    private SubjectControllerImpl subjectController;
    @Nullable
    private SessionControllerImpl sessionController;
    @Nullable
    private GdprControllerImpl gdprController;
    @Nullable
    private GlobalContextsControllerImpl globalContextsController;
    @NonNull
    private TrackerConfiguration trackerConfiguration;
    @Nullable
    private EmitterConfiguration emitterConfiguration;
    @Nullable
    private SubjectConfiguration subjectConfiguration;
    @Nullable
    private SessionConfiguration sessionConfiguration;
    @Nullable
    private GdprConfiguration gdprConfiguration;
    @Nullable
    private GlobalContextsConfiguration globalContextsConfiguration;
    @NonNull
    private TrackerConfigurationUpdate trackerConfigurationUpdate;
    @NonNull
    private NetworkConfigurationUpdate networkConfigurationUpdate;
    @NonNull
    private SubjectConfigurationUpdate subjectConfigurationUpdate;
    @NonNull
    private EmitterConfigurationUpdate emitterConfigurationUpdate;
    @NonNull
    private SessionConfigurationUpdate sessionConfigurationUpdate;
    @NonNull
    private GdprConfigurationUpdate gdprConfigurationUpdate;

    public ServiceProvider(@NonNull Context context, @NonNull String namespace, @NonNull NetworkConfiguration networkConfiguration, @NonNull List<Configuration> configurations) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(networkConfiguration);
        Objects.requireNonNull(configurations);
        this.namespace = namespace;
        this.context = context;
        this.appId = context.getPackageName();
        this.trackerConfigurationUpdate = new TrackerConfigurationUpdate(this.appId);
        this.networkConfigurationUpdate = new NetworkConfigurationUpdate();
        this.subjectConfigurationUpdate = new SubjectConfigurationUpdate();
        this.emitterConfigurationUpdate = new EmitterConfigurationUpdate();
        this.sessionConfigurationUpdate = new SessionConfigurationUpdate();
        this.gdprConfigurationUpdate = new GdprConfigurationUpdate();
        this.networkConfigurationUpdate.sourceConfig = networkConfiguration;
        this.trackerConfiguration = new TrackerConfiguration(this.appId);
        this.processConfigurations(configurations);
        if (this.trackerConfigurationUpdate.sourceConfig == null) {
            this.trackerConfigurationUpdate.sourceConfig = new TrackerConfiguration(this.appId);
        }
        this.getTracker();
    }

    public void reset(@NonNull List<Configuration> configurations) {
        this.stopServices();
        this.resetConfigurationUpdates();
        this.processConfigurations(configurations);
        this.resetServices();
        this.getTracker();
    }

    public void shutdown() {
        if (this.tracker != null) {
            this.tracker.pauseEventTracking();
        }
        this.stopServices();
        this.resetServices();
        this.resetControllers();
        this.initializeConfigurationUpdates();
    }

    @Override
    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    private void processConfigurations(@NonNull List<Configuration> configurations) {
        for (Configuration configuration : configurations) {
            if (configuration instanceof NetworkConfiguration) {
                this.networkConfigurationUpdate.sourceConfig = (NetworkConfiguration)configuration;
                continue;
            }
            if (configuration instanceof TrackerConfiguration) {
                this.trackerConfigurationUpdate.sourceConfig = (TrackerConfiguration)configuration;
                continue;
            }
            if (configuration instanceof SubjectConfiguration) {
                this.subjectConfigurationUpdate.sourceConfig = (SubjectConfiguration)configuration;
                continue;
            }
            if (configuration instanceof SessionConfiguration) {
                this.sessionConfigurationUpdate.sourceConfig = (SessionConfiguration)configuration;
                continue;
            }
            if (configuration instanceof EmitterConfiguration) {
                this.emitterConfigurationUpdate.sourceConfig = (EmitterConfiguration)configuration;
                continue;
            }
            if (configuration instanceof GdprConfiguration) {
                this.gdprConfigurationUpdate.sourceConfig = (GdprConfiguration)configuration;
                continue;
            }
            if (!(configuration instanceof GlobalContextsConfiguration)) continue;
            this.globalContextsConfiguration = (GlobalContextsConfiguration)configuration;
        }
    }

    private void stopServices() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.emitter != null) {
            this.emitter.shutdown();
        }
    }

    private void resetServices() {
        this.emitter = null;
        this.subject = null;
        this.tracker = null;
    }

    private void resetControllers() {
        this.trackerController = null;
        this.sessionController = null;
        this.emitterController = null;
        this.gdprController = null;
        this.globalContextsController = null;
        this.subjectController = null;
        this.networkController = null;
    }

    private void resetConfigurationUpdates() {
        this.trackerConfigurationUpdate.sourceConfig = new TrackerConfiguration(this.appId);
        this.subjectConfigurationUpdate.sourceConfig = null;
        this.emitterConfigurationUpdate.sourceConfig = null;
        this.sessionConfigurationUpdate.sourceConfig = null;
        this.gdprConfigurationUpdate.sourceConfig = null;
    }

    private void initializeConfigurationUpdates() {
        this.networkConfigurationUpdate = new NetworkConfigurationUpdate();
        this.trackerConfigurationUpdate = new TrackerConfigurationUpdate(this.appId);
        this.emitterConfigurationUpdate = new EmitterConfigurationUpdate();
        this.subjectConfigurationUpdate = new SubjectConfigurationUpdate();
        this.sessionConfigurationUpdate = new SessionConfigurationUpdate();
        this.gdprConfigurationUpdate = new GdprConfigurationUpdate();
    }

    @Override
    @NonNull
    public Subject getSubject() {
        if (this.subject == null) {
            this.subject = this.makeSubject();
        }
        return this.subject;
    }

    @Override
    @NonNull
    public Emitter getEmitter() {
        if (this.emitter == null) {
            this.emitter = this.makeEmitter();
        }
        return this.emitter;
    }

    @Override
    @NonNull
    public Tracker getTracker() {
        if (this.tracker == null) {
            this.tracker = this.makeTracker();
        }
        return this.tracker;
    }

    @Override
    @NonNull
    public TrackerControllerImpl getTrackerController() {
        if (this.trackerController == null) {
            this.trackerController = this.makeTrackerController();
        }
        return this.trackerController;
    }

    @Override
    @NonNull
    public SessionControllerImpl getSessionController() {
        if (this.sessionController == null) {
            this.sessionController = this.makeSessionController();
        }
        return this.sessionController;
    }

    @Override
    @NonNull
    public EmitterControllerImpl getEmitterController() {
        if (this.emitterController == null) {
            this.emitterController = this.makeEmitterController();
        }
        return this.emitterController;
    }

    @Override
    @NonNull
    public GdprControllerImpl getGdprController() {
        if (this.gdprController == null) {
            this.gdprController = this.makeGdprController();
        }
        return this.gdprController;
    }

    @Override
    @NonNull
    public GlobalContextsControllerImpl getGlobalContextsController() {
        if (this.globalContextsController == null) {
            this.globalContextsController = this.makeGlobalContextsController();
        }
        return this.globalContextsController;
    }

    @Override
    @NonNull
    public SubjectControllerImpl getSubjectController() {
        if (this.subjectController == null) {
            this.subjectController = this.makeSubjectController();
        }
        return this.subjectController;
    }

    @Override
    @NonNull
    public NetworkControllerImpl getNetworkController() {
        if (this.networkController == null) {
            this.networkController = this.makeNetworkController();
        }
        return this.networkController;
    }

    @Override
    @NonNull
    public TrackerConfigurationUpdate getTrackerConfigurationUpdate() {
        return this.trackerConfigurationUpdate;
    }

    @Override
    @NonNull
    public NetworkConfigurationUpdate getNetworkConfigurationUpdate() {
        return this.networkConfigurationUpdate;
    }

    @Override
    @NonNull
    public SubjectConfigurationUpdate getSubjectConfigurationUpdate() {
        return this.subjectConfigurationUpdate;
    }

    @Override
    @NonNull
    public EmitterConfigurationUpdate getEmitterConfigurationUpdate() {
        return this.emitterConfigurationUpdate;
    }

    @Override
    @NonNull
    public SessionConfigurationUpdate getSessionConfigurationUpdate() {
        return this.sessionConfigurationUpdate;
    }

    @Override
    @NonNull
    public GdprConfigurationUpdate getGdprConfigurationUpdate() {
        return this.gdprConfigurationUpdate;
    }

    @NonNull
    private Subject makeSubject() {
        return new Subject(this.context, this.subjectConfigurationUpdate);
    }

    @NonNull
    private Emitter makeEmitter() {
        String endpoint;
        Protocol protocol;
        NetworkConfigurationUpdate networkConfig = this.networkConfigurationUpdate;
        EmitterConfigurationUpdate emitterConfig = this.emitterConfigurationUpdate;
        Emitter.EmitterBuilder builder = new Emitter.EmitterBuilder().networkConnection(networkConfig.getNetworkConnection()).customPostPath(networkConfig.getCustomPostPath()).client(networkConfig.getOkHttpClient()).sendLimit(emitterConfig.getEmitRange()).option(emitterConfig.getBufferOption()).eventStore(emitterConfig.getEventStore()).byteLimitPost(emitterConfig.getByteLimitPost()).byteLimitGet(emitterConfig.getByteLimitGet()).threadPoolSize(emitterConfig.getThreadPoolSize()).callback(emitterConfig.getRequestCallback());
        HttpMethod method = networkConfig.getMethod();
        if (method != null) {
            builder.method(method);
        }
        if ((protocol = networkConfig.getProtocol()) != null) {
            builder.security(protocol);
        }
        if ((endpoint = networkConfig.getEndpoint()) == null) {
            endpoint = "";
        }
        Emitter emitter = new Emitter(this.context, endpoint, builder);
        if (this.emitterConfigurationUpdate.isPaused) {
            emitter.pauseEmit();
        }
        return emitter;
    }

    @NonNull
    private Tracker makeTracker() {
        Consumer<SessionState> onSessionUpdate;
        Session session;
        Emitter emitter = this.getEmitter();
        Subject subject = this.getSubject();
        TrackerConfigurationUpdate trackerConfig = this.getTrackerConfigurationUpdate();
        SessionConfigurationUpdate sessionConfig = this.getSessionConfigurationUpdate();
        Tracker.TrackerBuilder builder = new Tracker.TrackerBuilder(emitter, this.namespace, trackerConfig.getAppId(), this.context).subject(subject).trackerVersionSuffix(trackerConfig.getTrackerVersionSuffix()).base64(trackerConfig.isBase64encoding()).level(trackerConfig.getLogLevel()).loggerDelegate(trackerConfig.getLoggerDelegate()).platform(trackerConfig.getDevicePlatform()).sessionContext(trackerConfig.isSessionContext()).applicationContext(trackerConfig.isApplicationContext()).mobileContext(trackerConfig.isPlatformContext()).deepLinkContext(trackerConfig.isDeepLinkContext()).screenContext(trackerConfig.isScreenContext()).screenviewEvents(trackerConfig.isScreenViewAutotracking()).lifecycleEvents(trackerConfig.isLifecycleAutotracking()).installTracking(trackerConfig.isInstallAutotracking()).applicationCrash(trackerConfig.isExceptionAutotracking()).trackerDiagnostic(trackerConfig.isDiagnosticAutotracking()).backgroundTimeout(sessionConfig.getBackgroundTimeout().convert(TimeUnit.SECONDS)).foregroundTimeout(sessionConfig.getForegroundTimeout().convert(TimeUnit.SECONDS));
        GdprConfigurationUpdate gdprConfig = this.getGdprConfigurationUpdate();
        if (gdprConfig.sourceConfig != null) {
            builder.gdprContext(gdprConfig.getBasisForProcessing(), gdprConfig.getDocumentId(), gdprConfig.getDocumentVersion(), gdprConfig.getDocumentDescription());
        }
        Tracker tracker = new Tracker(builder);
        if (this.globalContextsConfiguration != null) {
            tracker.setGlobalContextGenerators(this.globalContextsConfiguration.contextGenerators);
        }
        if (this.trackerConfigurationUpdate.isPaused) {
            tracker.pauseEventTracking();
        }
        if (this.sessionConfigurationUpdate.isPaused) {
            tracker.pauseSessionChecking();
        }
        if ((session = tracker.getSession()) != null && (onSessionUpdate = this.sessionConfigurationUpdate.getOnSessionUpdate()) != null) {
            session.onSessionUpdate = onSessionUpdate;
        }
        return tracker;
    }

    @NonNull
    private TrackerControllerImpl makeTrackerController() {
        return new TrackerControllerImpl(this);
    }

    @NonNull
    private SessionControllerImpl makeSessionController() {
        return new SessionControllerImpl(this);
    }

    @NonNull
    private EmitterControllerImpl makeEmitterController() {
        return new EmitterControllerImpl(this);
    }

    @NonNull
    private GdprControllerImpl makeGdprController() {
        GdprControllerImpl controller = new GdprControllerImpl(this);
        Gdpr gdpr = this.getTracker().getGdprContext();
        if (gdpr != null) {
            controller.reset(gdpr.basisForProcessing, gdpr.documentId, gdpr.documentVersion, gdpr.documentDescription);
        }
        return controller;
    }

    @NonNull
    private GlobalContextsControllerImpl makeGlobalContextsController() {
        return new GlobalContextsControllerImpl(this);
    }

    @NonNull
    private SubjectControllerImpl makeSubjectController() {
        return new SubjectControllerImpl(this);
    }

    @NonNull
    private NetworkControllerImpl makeNetworkController() {
        return new NetworkControllerImpl(this);
    }
}

