/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import com.snowplowanalytics.snowplow.internal.tracker.StateFuture;
import com.snowplowanalytics.snowplow.internal.tracker.StateMachineInterface;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerState;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerStateSnapshot;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StateManager {
    private final HashMap<String, StateMachineInterface> identifierToStateMachine = new HashMap();
    private final HashMap<StateMachineInterface, String> stateMachineToIdentifier = new HashMap();
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToStateMachine = new HashMap();
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToEntitiesGenerator = new HashMap();
    private final HashMap<String, List<StateMachineInterface>> eventSchemaToPayloadUpdater = new HashMap();
    final TrackerState trackerState = new TrackerState();

    public synchronized void addOrReplaceStateMachine(@NonNull StateMachineInterface stateMachine, @NonNull String identifier) {
        StateMachineInterface previousStateMachine = this.identifierToStateMachine.get(identifier);
        if (previousStateMachine != null) {
            if (Objects.equals(stateMachine.getClass(), previousStateMachine.getClass())) {
                return;
            }
            this.removeStateMachine(identifier);
        }
        this.identifierToStateMachine.put(identifier, stateMachine);
        this.stateMachineToIdentifier.put(stateMachine, identifier);
        this.addToSchemaRegistry(this.eventSchemaToStateMachine, stateMachine.subscribedEventSchemasForTransitions(), stateMachine);
        this.addToSchemaRegistry(this.eventSchemaToEntitiesGenerator, stateMachine.subscribedEventSchemasForEntitiesGeneration(), stateMachine);
        this.addToSchemaRegistry(this.eventSchemaToPayloadUpdater, stateMachine.subscribedEventSchemasForPayloadUpdating(), stateMachine);
    }

    public synchronized boolean removeStateMachine(@NonNull String identifier) {
        StateMachineInterface stateMachine = this.identifierToStateMachine.remove(identifier);
        if (stateMachine == null) {
            return false;
        }
        this.stateMachineToIdentifier.remove(stateMachine);
        this.trackerState.removeState(identifier);
        this.removeFromSchemaRegistry(this.eventSchemaToStateMachine, stateMachine.subscribedEventSchemasForTransitions(), stateMachine);
        this.removeFromSchemaRegistry(this.eventSchemaToEntitiesGenerator, stateMachine.subscribedEventSchemasForEntitiesGeneration(), stateMachine);
        this.removeFromSchemaRegistry(this.eventSchemaToPayloadUpdater, stateMachine.subscribedEventSchemasForPayloadUpdating(), stateMachine);
        return true;
    }

    @NonNull
    synchronized TrackerStateSnapshot trackerStateForProcessedEvent(@NonNull Event event) {
        if (event instanceof AbstractSelfDescribing) {
            List<StateMachineInterface> stateMachinesGeneral;
            AbstractSelfDescribing sdEvent = (AbstractSelfDescribing)event;
            LinkedList<StateMachineInterface> stateMachines = new LinkedList<StateMachineInterface>();
            List<StateMachineInterface> stateMachinesForSchema = this.eventSchemaToStateMachine.get(sdEvent.getSchema());
            if (stateMachinesForSchema != null) {
                stateMachines.addAll(stateMachinesForSchema);
            }
            if ((stateMachinesGeneral = this.eventSchemaToStateMachine.get("*")) != null) {
                stateMachines.addAll(stateMachinesGeneral);
            }
            for (StateMachineInterface stateMachine : stateMachines) {
                String stateIdentifier = this.stateMachineToIdentifier.get(stateMachine);
                StateFuture previousStateFuture = this.trackerState.getStateFuture(stateIdentifier);
                StateFuture currentStateFuture = new StateFuture(sdEvent, previousStateFuture, stateMachine);
                this.trackerState.put(stateIdentifier, currentStateFuture);
                currentStateFuture.getState();
            }
        }
        return this.trackerState.getSnapshot();
    }

    @NonNull
    synchronized List<SelfDescribingJson> entitiesForProcessedEvent(@NonNull InspectableEvent event) {
        List<StateMachineInterface> stateMachinesGeneral;
        LinkedList<SelfDescribingJson> result = new LinkedList<SelfDescribingJson>();
        LinkedList<StateMachineInterface> stateMachines = new LinkedList<StateMachineInterface>();
        List<StateMachineInterface> stateMachinesForSchema = this.eventSchemaToEntitiesGenerator.get(event.getSchema());
        if (stateMachinesForSchema != null) {
            stateMachines.addAll(stateMachinesForSchema);
        }
        if ((stateMachinesGeneral = this.eventSchemaToEntitiesGenerator.get("*")) != null) {
            stateMachines.addAll(stateMachinesGeneral);
        }
        for (StateMachineInterface stateMachine : stateMachines) {
            String stateIdentifier = this.stateMachineToIdentifier.get(stateMachine);
            State state = event.getState().getState(stateIdentifier);
            List<SelfDescribingJson> entities = stateMachine.entities(event, state);
            if (entities == null) continue;
            result.addAll(entities);
        }
        return result;
    }

    public synchronized boolean addPayloadValuesToEvent(@NonNull InspectableEvent event) {
        List<StateMachineInterface> stateMachinesGeneral;
        int failures = 0;
        LinkedList<StateMachineInterface> stateMachines = new LinkedList<StateMachineInterface>();
        List<StateMachineInterface> stateMachinesForSchema = this.eventSchemaToPayloadUpdater.get(event.getSchema());
        if (stateMachinesForSchema != null) {
            stateMachines.addAll(stateMachinesForSchema);
        }
        if ((stateMachinesGeneral = this.eventSchemaToPayloadUpdater.get("*")) != null) {
            stateMachines.addAll(stateMachinesGeneral);
        }
        for (StateMachineInterface stateMachine : stateMachines) {
            String stateIdentifier = this.stateMachineToIdentifier.get(stateMachine);
            State state = event.getState().getState(stateIdentifier);
            Map<String, Object> payloadValues = stateMachine.payloadValues(event, state);
            if (payloadValues == null || event.addPayloadValues(payloadValues)) continue;
            ++failures;
        }
        return failures == 0;
    }

    private void addToSchemaRegistry(Map<String, List<StateMachineInterface>> schemaRegistry, List<String> schemas, StateMachineInterface stateMachine) {
        for (String eventSchema : schemas) {
            List<StateMachineInterface> list = schemaRegistry.get(eventSchema);
            if (list == null) {
                list = new LinkedList<StateMachineInterface>();
                schemaRegistry.put(eventSchema, list);
            }
            list.add(stateMachine);
        }
    }

    private void removeFromSchemaRegistry(Map<String, List<StateMachineInterface>> schemaRegistry, List<String> schemas, StateMachineInterface stateMachine) {
        for (String eventSchema : schemas) {
            List<StateMachineInterface> list = schemaRegistry.get(eventSchema);
            if (list == null) continue;
            list.remove(stateMachine);
        }
    }
}

