/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import android.content.Context;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.tracker.SubjectConfigurationInterface;
import com.snowplowanalytics.snowplow.util.Size;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class Subject {
    private static final String TAG = Subject.class.getSimpleName();
    private final HashMap<String, String> standardPairs = new HashMap();
    @Nullable
    String userId;
    @Nullable
    String networkUserId;
    @Nullable
    String domainUserId;
    @Nullable
    String useragent;
    @Nullable
    String ipAddress;
    @Nullable
    String timezone;
    @Nullable
    String language;
    @Nullable
    Size screenResolution;
    @Nullable
    Size screenViewPort;
    @Nullable
    Integer colorDepth;

    public Subject(@NonNull Context context, @Nullable SubjectConfigurationInterface config) {
        this.setDefaultTimezone();
        this.setDefaultLanguage();
        this.setDefaultScreenResolution(context);
        if (config != null) {
            Size size;
            if (config.getUserId() != null) {
                this.setUserId(config.getUserId());
            }
            if (config.getNetworkUserId() != null) {
                this.setNetworkUserId(config.getNetworkUserId());
            }
            if (config.getDomainUserId() != null) {
                this.setDomainUserId(config.getDomainUserId());
            }
            if (config.getUseragent() != null) {
                this.setUseragent(config.getUseragent());
            }
            if (config.getIpAddress() != null) {
                this.setIpAddress(config.getIpAddress());
            }
            if (config.getTimezone() != null) {
                this.setTimezone(config.getTimezone());
            }
            if (config.getLanguage() != null) {
                this.setLanguage(config.getLanguage());
            }
            if (config.getScreenResolution() != null) {
                size = config.getScreenResolution();
                this.setScreenResolution(size.getWidth(), size.getHeight());
            }
            if (config.getScreenViewPort() != null) {
                size = config.getScreenViewPort();
                this.setViewPort(size.getWidth(), size.getHeight());
            }
            if (config.getColorDepth() != null) {
                this.setColorDepth(config.getColorDepth());
            }
        }
        Logger.v(TAG, "Subject created successfully.", new Object[0]);
    }

    private void setDefaultTimezone() {
        TimeZone tz = Calendar.getInstance().getTimeZone();
        this.setTimezone(tz.getID());
    }

    private void setDefaultLanguage() {
        this.setLanguage(Locale.getDefault().getDisplayLanguage());
    }

    public void setDefaultScreenResolution(@NonNull Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        this.setScreenResolution(size.x, size.y);
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
        this.standardPairs.put("uid", userId);
    }

    public void setScreenResolution(int width, int height) {
        this.screenResolution = new Size(width, height);
        String res = Integer.toString(width) + "x" + Integer.toString(height);
        this.standardPairs.put("res", res);
    }

    public void setViewPort(int width, int height) {
        this.screenViewPort = new Size(width, height);
        String res = Integer.toString(width) + "x" + Integer.toString(height);
        this.standardPairs.put("vp", res);
    }

    public void setColorDepth(int depth) {
        this.colorDepth = depth;
        this.standardPairs.put("cd", Integer.toString(depth));
    }

    public void setTimezone(@NonNull String timezone) {
        this.timezone = timezone;
        this.standardPairs.put("tz", timezone);
    }

    public void setLanguage(@NonNull String language) {
        this.language = language;
        this.standardPairs.put("lang", language);
    }

    public void setIpAddress(@NonNull String ipAddress) {
        this.ipAddress = ipAddress;
        this.standardPairs.put("ip", ipAddress);
    }

    public void setUseragent(@NonNull String useragent) {
        this.useragent = useragent;
        this.standardPairs.put("ua", useragent);
    }

    public void setNetworkUserId(@NonNull String networkUserId) {
        this.networkUserId = networkUserId;
        this.standardPairs.put("tnuid", networkUserId);
    }

    public void setDomainUserId(@NonNull String domainUserId) {
        this.domainUserId = domainUserId;
        this.standardPairs.put("duid", domainUserId);
    }

    @NonNull
    public Map<String, String> getSubject() {
        return this.standardPairs;
    }
}

