/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.Background;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.event.Foreground;
import com.snowplowanalytics.snowplow.event.TrackerError;
import com.snowplowanalytics.snowplow.globalcontexts.GlobalContext;
import com.snowplowanalytics.snowplow.internal.emitter.Emitter;
import com.snowplowanalytics.snowplow.internal.emitter.Executor;
import com.snowplowanalytics.snowplow.internal.gdpr.Gdpr;
import com.snowplowanalytics.snowplow.internal.session.ProcessObserver;
import com.snowplowanalytics.snowplow.internal.session.Session;
import com.snowplowanalytics.snowplow.internal.tracker.ActivityLifecycleHandler;
import com.snowplowanalytics.snowplow.internal.tracker.DeepLinkStateMachine;
import com.snowplowanalytics.snowplow.internal.tracker.ExceptionHandler;
import com.snowplowanalytics.snowplow.internal.tracker.InstallTracker;
import com.snowplowanalytics.snowplow.internal.tracker.LifecycleStateMachine;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.tracker.PlatformContext;
import com.snowplowanalytics.snowplow.internal.tracker.ScreenState;
import com.snowplowanalytics.snowplow.internal.tracker.ScreenStateMachine;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import com.snowplowanalytics.snowplow.internal.tracker.StateManager;
import com.snowplowanalytics.snowplow.internal.tracker.Subject;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerEvent;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerStateSnapshot;
import com.snowplowanalytics.snowplow.internal.utils.NotificationCenter;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.Payload;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import com.snowplowanalytics.snowplow.tracker.DevicePlatform;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import com.snowplowanalytics.snowplow.tracker.LogLevel;
import com.snowplowanalytics.snowplow.tracker.LoggerDelegate;
import com.snowplowanalytics.snowplow.util.Basis;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracker {
    private static final String TAG = Tracker.class.getSimpleName();
    private String trackerVersion = "andr-3.1.1";
    final Context context;
    Emitter emitter;
    Subject subject;
    Session trackerSession;
    String namespace;
    String appId;
    boolean base64Encoded;
    DevicePlatform devicePlatform;
    LogLevel level;
    private boolean sessionContext;
    Runnable[] sessionCallbacks;
    int threadCount;
    boolean geoLocationContext;
    boolean mobileContext;
    boolean applicationCrash;
    boolean trackerDiagnostic;
    boolean lifecycleEvents;
    boolean installTracking;
    boolean activityTracking;
    boolean applicationContext;
    String trackerVersionSuffix;
    private boolean deepLinkContext;
    private boolean screenContext;
    private Gdpr gdpr;
    private final StateManager stateManager;
    private final TimeUnit timeUnit;
    private final long foregroundTimeout;
    private final long backgroundTimeout;
    @NonNull
    private final PlatformContext platformContext;
    private final Map<String, GlobalContext> globalContextGenerators = Collections.synchronizedMap(new HashMap());
    private final NotificationCenter.FunctionalObserver receiveLifecycleNotification = new NotificationCenter.FunctionalObserver(){

        @Override
        public void apply(@NonNull Map<String, Object> data) {
            Session session = Tracker.this.getSession();
            if (session == null || !Tracker.this.lifecycleEvents) {
                return;
            }
            Boolean isForeground = (Boolean)data.get("isForeground");
            if (isForeground == null) {
                return;
            }
            if (session.isBackground() == (isForeground == false)) {
                return;
            }
            if (isForeground.booleanValue()) {
                Tracker.this.track(new Foreground().foregroundIndex(session.getForegroundIndex() + 1));
            } else {
                Tracker.this.track(new Background().backgroundIndex(session.getBackgroundIndex() + 1));
            }
            session.setBackground(isForeground == false);
        }
    };
    private final NotificationCenter.FunctionalObserver receiveScreenViewNotification = new NotificationCenter.FunctionalObserver(){

        @Override
        public void apply(@NonNull Map<String, Object> data) {
            Event event;
            if (Tracker.this.activityTracking && (event = (Event)data.get("event")) != null) {
                Tracker.this.track(event);
            }
        }
    };
    private final NotificationCenter.FunctionalObserver receiveInstallNotification = new NotificationCenter.FunctionalObserver(){

        @Override
        public void apply(@NonNull Map<String, Object> data) {
            Event event;
            if (Tracker.this.installTracking && (event = (Event)data.get("event")) != null) {
                Tracker.this.track(event);
            }
        }
    };
    private final NotificationCenter.FunctionalObserver receiveDiagnosticNotification = new NotificationCenter.FunctionalObserver(){

        @Override
        public void apply(@NonNull Map<String, Object> data) {
            Event event;
            if (Tracker.this.trackerDiagnostic && (event = (Event)data.get("event")) != null) {
                Tracker.this.track(event);
            }
        }
    };
    private final NotificationCenter.FunctionalObserver receiveCrashReportingNotification = new NotificationCenter.FunctionalObserver(){

        @Override
        public void apply(@NonNull Map<String, Object> data) {
            Event event;
            if (Tracker.this.applicationCrash && (event = (Event)data.get("event")) != null) {
                Tracker.this.track(event);
            }
        }
    };
    AtomicBoolean dataCollection = new AtomicBoolean(true);

    public Tracker(@NonNull TrackerBuilder builder) {
        String suffix;
        this.stateManager = new StateManager();
        this.context = builder.context;
        this.emitter = builder.emitter;
        this.emitter.flush();
        this.namespace = builder.namespace;
        this.emitter.setNamespace(this.namespace);
        this.appId = builder.appId;
        this.base64Encoded = builder.base64Encoded;
        this.subject = builder.subject;
        this.devicePlatform = builder.devicePlatform;
        this.sessionContext = builder.sessionContext;
        this.sessionCallbacks = builder.sessionCallbacks;
        this.threadCount = Math.max(builder.threadCount, 2);
        this.geoLocationContext = builder.geoLocationContext;
        this.mobileContext = builder.mobileContext;
        this.applicationCrash = builder.applicationCrash;
        this.trackerDiagnostic = builder.trackerDiagnostic;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.activityTracking = builder.activityTracking;
        this.installTracking = builder.installTracking;
        this.applicationContext = builder.applicationContext;
        this.gdpr = builder.gdpr;
        this.level = builder.logLevel;
        this.trackerVersionSuffix = builder.trackerVersionSuffix;
        this.timeUnit = builder.timeUnit;
        this.foregroundTimeout = builder.foregroundTimeout;
        this.backgroundTimeout = builder.backgroundTimeout;
        this.platformContext = new PlatformContext(this.context);
        this.setScreenContext(builder.screenContext);
        this.setDeepLinkContext(builder.deepLinkContext);
        if (this.trackerVersionSuffix != null && !(suffix = this.trackerVersionSuffix.replaceAll("[^A-Za-z0-9.-]", "")).isEmpty()) {
            this.trackerVersion = this.trackerVersion + " " + suffix;
        }
        if (this.trackerDiagnostic) {
            if (this.level == LogLevel.OFF) {
                this.level = LogLevel.ERROR;
            }
            Logger.updateLogLevel(this.level);
        }
        if (this.sessionContext) {
            Runnable[] callbacks = new Runnable[]{null, null, null, null};
            if (this.sessionCallbacks.length == 4) {
                callbacks = this.sessionCallbacks;
            }
            this.trackerSession = Session.getInstance(this.context, this.foregroundTimeout, this.backgroundTimeout, this.timeUnit, this.namespace, callbacks);
        }
        this.registerNotificationHandlers();
        this.initializeCrashReporting();
        this.initializeInstallTracking();
        this.initializeScreenviewTracking();
        this.initializeLifecycleTracking();
        this.resumeSessionChecking();
        Logger.v(TAG, "Tracker created successfully.", new Object[0]);
    }

    private void registerNotificationHandlers() {
        NotificationCenter.addObserver("SnowplowTrackerDiagnostic", this.receiveDiagnosticNotification);
        NotificationCenter.addObserver("SnowplowScreenView", this.receiveScreenViewNotification);
        NotificationCenter.addObserver("SnowplowLifecycleTracking", this.receiveLifecycleNotification);
        NotificationCenter.addObserver("SnowplowInstallTracking", this.receiveInstallNotification);
        NotificationCenter.addObserver("SnowplowCrashReporting", this.receiveCrashReportingNotification);
    }

    private void unregisterNotificationHandlers() {
        NotificationCenter.removeObserver(this.receiveDiagnosticNotification);
        NotificationCenter.removeObserver(this.receiveScreenViewNotification);
        NotificationCenter.removeObserver(this.receiveLifecycleNotification);
        NotificationCenter.removeObserver(this.receiveInstallNotification);
        NotificationCenter.removeObserver(this.receiveCrashReportingNotification);
    }

    private void initializeInstallTracking() {
        if (this.installTracking) {
            InstallTracker.getInstance(this.context);
        }
    }

    private void initializeScreenviewTracking() {
        if (this.activityTracking) {
            ActivityLifecycleHandler.getInstance(this.context);
        }
    }

    private void initializeLifecycleTracking() {
        if (this.lifecycleEvents) {
            ProcessObserver.initialize(this.context);
            this.stateManager.addOrReplaceStateMachine(new LifecycleStateMachine(), "Lifecycle");
        }
    }

    private void initializeCrashReporting() {
        if (this.applicationCrash && !(Thread.getDefaultUncaughtExceptionHandler() instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        }
    }

    public void close() {
        this.unregisterNotificationHandlers();
        this.pauseSessionChecking();
        this.getEmitter().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(@NonNull Event event) {
        TrackerEvent trackerEvent;
        if (!this.dataCollection.get()) {
            return;
        }
        event.beginProcessing(this);
        Tracker tracker = this;
        synchronized (tracker) {
            TrackerStateSnapshot stateSnapshot = this.stateManager.trackerStateForProcessedEvent(event);
            trackerEvent = new TrackerEvent(event, stateSnapshot);
            this.workaroundForIncoherentSessionContext(trackerEvent);
        }
        boolean reportsOnDiagnostic = !(event instanceof TrackerError);
        Executor.execute(reportsOnDiagnostic, TAG, () -> {
            this.transformEvent(trackerEvent);
            Payload payload = this.payloadWithEvent(trackerEvent);
            Logger.v(TAG, "Adding new payload to event storage: %s", payload);
            this.emitter.add(payload);
            event.endProcessing(this);
        });
    }

    private void transformEvent(@NonNull TrackerEvent event) {
        if (event.schema != null && event.schema.equals("iglu:com.snowplowanalytics.mobile/application_install/jsonschema/1-0-0") && event.trueTimestamp != null) {
            event.timestamp = event.trueTimestamp;
            event.trueTimestamp = null;
        }
        this.stateManager.addPayloadValuesToEvent(event);
    }

    @NonNull
    private Payload payloadWithEvent(@NonNull TrackerEvent event) {
        TrackerPayload payload = new TrackerPayload();
        this.addBasicPropertiesToPayload(payload, event);
        if (event.isPrimitive) {
            this.addPrimitivePropertiesToPayload(payload, event);
        } else {
            this.addSelfDescribingPropertiesToPayload(payload, event);
        }
        List<SelfDescribingJson> contexts = event.contexts;
        this.addBasicContextsToContexts(contexts, event);
        this.addGlobalContextsToContexts(contexts, event);
        this.addStateMachineEntitiesToContexts(contexts, event);
        this.wrapContextsToPayload(payload, contexts);
        return payload;
    }

    private void addBasicPropertiesToPayload(@NonNull Payload payload, @NonNull TrackerEvent event) {
        payload.add("eid", event.eventId.toString());
        payload.add("dtm", Long.toString(event.timestamp));
        if (event.trueTimestamp != null) {
            payload.add("ttm", event.trueTimestamp.toString());
        }
        payload.add("aid", this.appId);
        payload.add("tna", this.namespace);
        payload.add("tv", this.trackerVersion);
        if (this.subject != null) {
            payload.addMap(new HashMap<String, Object>(this.subject.getSubject()));
        }
        payload.add("p", this.devicePlatform.getValue());
    }

    private void addPrimitivePropertiesToPayload(@NonNull Payload payload, @NonNull TrackerEvent event) {
        payload.add("e", event.eventName);
        payload.addMap(event.payload);
    }

    private void addSelfDescribingPropertiesToPayload(@NonNull Payload payload, @NonNull TrackerEvent event) {
        payload.add("e", "ue");
        this.workaroundForCampaignAttributionEnrichment(payload, event);
        SelfDescribingJson data = new SelfDescribingJson(event.schema, event.payload);
        HashMap<String, Object> unstructuredEventPayload = new HashMap<String, Object>();
        unstructuredEventPayload.put("schema", "iglu:com.snowplowanalytics.snowplow/unstruct_event/jsonschema/1-0-0");
        unstructuredEventPayload.put("data", data.getMap());
        payload.addMap(unstructuredEventPayload, this.base64Encoded, "ue_px", "ue_pr");
    }

    private void workaroundForCampaignAttributionEnrichment(@NonNull Payload payload, @NonNull TrackerEvent event) {
        if (event.schema.equals("iglu:com.snowplowanalytics.mobile/deep_link_received/jsonschema/1-0-0") && event.payload != null) {
            String url = (String)event.payload.get("url");
            String referrer = (String)event.payload.get("referrer");
            payload.add("url", url);
            payload.add("refr", referrer);
        }
    }

    private void workaroundForIncoherentSessionContext(@NonNull TrackerEvent event) {
        if (!event.isService && this.sessionContext) {
            String eventId = event.eventId.toString();
            Session sessionManager = this.trackerSession;
            if (sessionManager == null) {
                Logger.track(TAG, "Session not ready or method getHasLoadedFromFile returned false with eventId: %s", eventId);
                return;
            }
            SelfDescribingJson sessionContextJson = sessionManager.getSessionContext(eventId);
            event.contexts.add(sessionContextJson);
        }
    }

    private void addBasicContextsToContexts(@NonNull List<SelfDescribingJson> contexts, @NonNull TrackerEvent event) {
        if (this.applicationContext) {
            contexts.add(Util.getApplicationContext(this.context));
        }
        if (this.mobileContext) {
            contexts.add(this.platformContext.getMobileContext());
        }
        if (event.isService) {
            return;
        }
        if (this.geoLocationContext) {
            contexts.add(Util.getGeoLocationContext(this.context));
        }
        if (this.gdpr != null) {
            contexts.add(this.gdpr.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlobalContextsToContexts(@NonNull List<SelfDescribingJson> contexts, @NonNull InspectableEvent event) {
        Map<String, GlobalContext> map = this.globalContextGenerators;
        synchronized (map) {
            for (GlobalContext generator : this.globalContextGenerators.values()) {
                contexts.addAll(generator.generateContexts(event));
            }
        }
    }

    private void addStateMachineEntitiesToContexts(@NonNull List<SelfDescribingJson> contexts, @NonNull InspectableEvent event) {
        List<SelfDescribingJson> stateManagerEntities = this.stateManager.entitiesForProcessedEvent(event);
        contexts.addAll(stateManagerEntities);
    }

    private void wrapContextsToPayload(@NonNull Payload payload, @NonNull List<SelfDescribingJson> contexts) {
        if (contexts.isEmpty()) {
            return;
        }
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        for (SelfDescribingJson context : contexts) {
            if (context == null) continue;
            data.add(context.getMap());
        }
        SelfDescribingJson finalContext = new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/contexts/jsonschema/1-0-1", data);
        payload.addMap(finalContext.getMap(), this.base64Encoded, "cx", "co");
    }

    private void addServiceEventPayload(@NonNull Payload payload, @NonNull List<SelfDescribingJson> contexts) {
        payload.add("p", this.devicePlatform.getValue());
        payload.add("aid", this.appId);
        payload.add("tna", this.namespace);
        payload.add("tv", this.trackerVersion);
        if (this.subject != null) {
            payload.addMap(new HashMap<String, Object>(this.subject.getSubject()));
        }
        if (this.mobileContext) {
            contexts.add(this.platformContext.getMobileContext());
        }
        if (this.applicationContext) {
            contexts.add(Util.getApplicationContext(this.context));
        }
        if (contexts.size() > 0) {
            LinkedList<Map<String, Object>> contextMaps = new LinkedList<Map<String, Object>>();
            for (SelfDescribingJson selfDescribingJson : contexts) {
                if (selfDescribingJson == null) continue;
                contextMaps.add(selfDescribingJson.getMap());
            }
            SelfDescribingJson envelope = new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/contexts/jsonschema/1-0-1", contextMaps);
            payload.addMap(envelope.getMap(), this.base64Encoded, "cx", "co");
        }
        this.emitter.add(payload);
    }

    public void resumeEventTracking() {
        if (this.dataCollection.compareAndSet(false, true)) {
            this.resumeSessionChecking();
            this.getEmitter().flush();
        }
    }

    public void pauseEventTracking() {
        if (this.dataCollection.compareAndSet(true, false)) {
            this.pauseSessionChecking();
            this.getEmitter().shutdown();
        }
    }

    public void resumeSessionChecking() {
        Session trackerSession = this.trackerSession;
        if (trackerSession != null) {
            trackerSession.setIsSuspended(false);
            Logger.d(TAG, "Session checking has been resumed.", new Object[0]);
        }
    }

    public void pauseSessionChecking() {
        Session trackerSession = this.trackerSession;
        if (trackerSession != null) {
            trackerSession.setIsSuspended(true);
            Logger.d(TAG, "Session checking has been paused.", new Object[0]);
        }
    }

    public void startNewSession() {
        this.trackerSession.startNewSession();
    }

    public void enableGdprContext(@NonNull Basis basisForProcessing, @Nullable String documentId, @Nullable String documentVersion, @Nullable String documentDescription) {
        this.gdpr = new Gdpr(basisForProcessing, documentId, documentVersion, documentDescription);
    }

    public synchronized void disableGdprContext() {
        this.gdpr = null;
    }

    @Nullable
    public Gdpr getGdprContext() {
        return this.gdpr;
    }

    public void setSubject(@Nullable Subject subject) {
        this.subject = subject;
    }

    public void setEmitter(@NonNull Emitter emitter) {
        this.getEmitter().shutdown();
        this.emitter = emitter;
    }

    public synchronized void setSessionContext(boolean sessionContext) {
        this.sessionContext = sessionContext;
        if (this.trackerSession != null && !sessionContext) {
            this.pauseSessionChecking();
            this.trackerSession = null;
        } else if (this.trackerSession == null && sessionContext) {
            Runnable[] callbacks = new Runnable[]{null, null, null, null};
            if (this.sessionCallbacks.length == 4) {
                callbacks = this.sessionCallbacks;
            }
            this.trackerSession = Session.getInstance(this.context, this.foregroundTimeout, this.backgroundTimeout, this.timeUnit, this.namespace, callbacks);
        }
    }

    public void setPlatform(@NonNull DevicePlatform platform) {
        this.devicePlatform = platform;
    }

    public void setScreenContext(boolean screenContext) {
        this.screenContext = screenContext;
        if (screenContext) {
            this.stateManager.addOrReplaceStateMachine(new ScreenStateMachine(), "ScreenContext");
        } else {
            this.stateManager.removeStateMachine("ScreenContext");
        }
    }

    public void setDeepLinkContext(boolean deepLinkContext) {
        this.deepLinkContext = deepLinkContext;
        if (this.deepLinkContext) {
            this.stateManager.addOrReplaceStateMachine(new DeepLinkStateMachine(), "DeepLinkContext");
        } else {
            this.stateManager.removeStateMachine("DeepLinkContext");
        }
    }

    public boolean getScreenContext() {
        return this.screenContext;
    }

    public boolean getDeepLinkContext() {
        return this.deepLinkContext;
    }

    public boolean getSessionContext() {
        return this.sessionContext;
    }

    @NonNull
    public String getTrackerVersion() {
        return this.trackerVersion;
    }

    @Nullable
    public Subject getSubject() {
        return this.subject;
    }

    @NonNull
    public Emitter getEmitter() {
        return this.emitter;
    }

    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    @NonNull
    public String getAppId() {
        return this.appId;
    }

    public boolean getBase64Encoded() {
        return this.base64Encoded;
    }

    public boolean getInstallTracking() {
        return this.installTracking;
    }

    public boolean getApplicationContext() {
        return this.applicationContext;
    }

    @NonNull
    public DevicePlatform getPlatform() {
        return this.devicePlatform;
    }

    @NonNull
    public LogLevel getLogLevel() {
        return this.level;
    }

    @Nullable
    public Session getSession() {
        return this.trackerSession;
    }

    public boolean getDataCollection() {
        return this.dataCollection.get();
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public boolean getApplicationCrash() {
        return this.applicationCrash;
    }

    public boolean getLifecycleEvents() {
        return this.lifecycleEvents;
    }

    public boolean getActivityTracking() {
        return this.activityTracking;
    }

    @Nullable
    public ScreenState getScreenState() {
        State state = this.stateManager.trackerState.getState("ScreenContext");
        if (state == null) {
            return new ScreenState();
        }
        if (state instanceof ScreenState) {
            return (ScreenState)state;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalContextGenerators(@NonNull Map<String, GlobalContext> globalContexts) {
        Objects.requireNonNull(globalContexts);
        Map<String, GlobalContext> map = this.globalContextGenerators;
        synchronized (map) {
            this.globalContextGenerators.clear();
            this.globalContextGenerators.putAll(globalContexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addGlobalContext(@NonNull GlobalContext generator, @NonNull String tag) {
        Objects.requireNonNull(generator);
        Objects.requireNonNull(tag);
        Map<String, GlobalContext> map = this.globalContextGenerators;
        synchronized (map) {
            if (this.globalContextGenerators.containsKey(tag)) {
                return false;
            }
            this.globalContextGenerators.put(tag, generator);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GlobalContext removeGlobalContext(@NonNull String tag) {
        Objects.requireNonNull(tag);
        Map<String, GlobalContext> map = this.globalContextGenerators;
        synchronized (map) {
            return this.globalContextGenerators.remove(tag);
        }
    }

    @NonNull
    public Set<String> getGlobalContextTags() {
        return this.globalContextGenerators.keySet();
    }

    public static class TrackerBuilder {
        @NonNull
        final Emitter emitter;
        @NonNull
        final String namespace;
        @NonNull
        final String appId;
        @NonNull
        final Context context;
        @Nullable
        Subject subject = null;
        boolean base64Encoded = true;
        @Nullable
        DevicePlatform devicePlatform = DevicePlatform.Mobile;
        LogLevel logLevel = LogLevel.OFF;
        boolean sessionContext = false;
        long foregroundTimeout = 600L;
        long backgroundTimeout = 300L;
        @NonNull
        Runnable[] sessionCallbacks = new Runnable[0];
        int threadCount = 10;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        boolean geoLocationContext = false;
        boolean mobileContext = false;
        boolean applicationCrash = true;
        boolean trackerDiagnostic = false;
        boolean lifecycleEvents = false;
        boolean deepLinkContext = true;
        boolean screenContext = false;
        boolean activityTracking = false;
        boolean installTracking = false;
        boolean applicationContext = false;
        @Nullable
        Gdpr gdpr = null;
        @Nullable
        String trackerVersionSuffix = null;

        public TrackerBuilder(@NonNull Emitter emitter, @NonNull String namespace, @NonNull String appId, @NonNull Context context) {
            this.emitter = emitter;
            this.namespace = namespace;
            this.appId = appId;
            this.context = context;
        }

        @NonNull
        public TrackerBuilder applicationContext(boolean isEnabled) {
            this.applicationContext = isEnabled;
            return this;
        }

        @NonNull
        public TrackerBuilder gdprContext(@NonNull Basis basisForProcessing, @Nullable String documentId, @Nullable String documentVersion, @Nullable String documentDescription) {
            this.gdpr = new Gdpr(basisForProcessing, documentId, documentVersion, documentDescription);
            return this;
        }

        @NonNull
        public TrackerBuilder installTracking(boolean willTrack) {
            this.installTracking = willTrack;
            return this;
        }

        @NonNull
        public TrackerBuilder subject(@Nullable Subject subject) {
            this.subject = subject;
            return this;
        }

        @NonNull
        public TrackerBuilder base64(@Nullable Boolean base64) {
            this.base64Encoded = base64;
            return this;
        }

        @NonNull
        public TrackerBuilder platform(@Nullable DevicePlatform platform) {
            this.devicePlatform = platform;
            return this;
        }

        @NonNull
        public TrackerBuilder level(@Nullable LogLevel log) {
            this.logLevel = log;
            return this;
        }

        @NonNull
        public TrackerBuilder loggerDelegate(@Nullable LoggerDelegate delegate) {
            Logger.setDelegate(delegate);
            return this;
        }

        @NonNull
        public TrackerBuilder sessionContext(boolean sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        @NonNull
        public TrackerBuilder foregroundTimeout(long timeout) {
            this.foregroundTimeout = timeout;
            return this;
        }

        @NonNull
        public TrackerBuilder backgroundTimeout(long timeout) {
            this.backgroundTimeout = timeout;
            return this;
        }

        @NonNull
        public TrackerBuilder sessionCallbacks(@NonNull Runnable foregroundTransitionCallback, @NonNull Runnable backgroundTransitionCallback, @NonNull Runnable foregroundTimeoutCallback, @NonNull Runnable backgroundTimeoutCallback) {
            this.sessionCallbacks = new Runnable[]{foregroundTransitionCallback, backgroundTransitionCallback, foregroundTimeoutCallback, backgroundTimeoutCallback};
            return this;
        }

        @NonNull
        public TrackerBuilder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        @NonNull
        public TrackerBuilder timeUnit(@Nullable TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @NonNull
        public TrackerBuilder geoLocationContext(@NonNull Boolean geoLocationContext) {
            this.geoLocationContext = geoLocationContext;
            return this;
        }

        @NonNull
        public TrackerBuilder mobileContext(@NonNull Boolean mobileContext) {
            this.mobileContext = mobileContext;
            return this;
        }

        @NonNull
        public TrackerBuilder applicationCrash(@NonNull Boolean applicationCrash) {
            this.applicationCrash = applicationCrash;
            return this;
        }

        @NonNull
        public TrackerBuilder trackerDiagnostic(@NonNull Boolean trackerDiagnostic) {
            this.trackerDiagnostic = trackerDiagnostic;
            return this;
        }

        @NonNull
        public TrackerBuilder lifecycleEvents(@NonNull Boolean lifecycleEvents) {
            this.lifecycleEvents = lifecycleEvents;
            return this;
        }

        @NonNull
        public TrackerBuilder deepLinkContext(@NonNull Boolean deepLinkContext) {
            this.deepLinkContext = deepLinkContext;
            return this;
        }

        @NonNull
        public synchronized TrackerBuilder screenContext(@NonNull Boolean screenContext) {
            this.screenContext = screenContext;
            return this;
        }

        @NonNull
        public TrackerBuilder screenviewEvents(@NonNull Boolean screenviewEvents) {
            this.activityTracking = screenviewEvents;
            return this;
        }

        @NonNull
        public TrackerBuilder trackerVersionSuffix(@Nullable String trackerVersionSuffix) {
            this.trackerVersionSuffix = trackerVersionSuffix;
            return this;
        }
    }
}

