/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.snowplowanalytics.snowplow.controller.EmitterController;
import com.snowplowanalytics.snowplow.controller.GdprController;
import com.snowplowanalytics.snowplow.controller.GlobalContextsController;
import com.snowplowanalytics.snowplow.controller.NetworkController;
import com.snowplowanalytics.snowplow.controller.SessionController;
import com.snowplowanalytics.snowplow.controller.SubjectController;
import com.snowplowanalytics.snowplow.controller.TrackerController;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.internal.Controller;
import com.snowplowanalytics.snowplow.internal.session.SessionControllerImpl;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.tracker.ServiceProvider;
import com.snowplowanalytics.snowplow.internal.tracker.Tracker;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerConfigurationUpdate;
import com.snowplowanalytics.snowplow.tracker.DevicePlatform;
import com.snowplowanalytics.snowplow.tracker.LogLevel;
import com.snowplowanalytics.snowplow.tracker.LoggerDelegate;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class TrackerControllerImpl
extends Controller
implements TrackerController {
    public TrackerControllerImpl(@NonNull ServiceProvider serviceProvider) {
        super(serviceProvider);
    }

    @Override
    @Nullable
    public NetworkController getNetwork() {
        return this.serviceProvider.getNetworkController();
    }

    @Override
    @NonNull
    public EmitterController getEmitter() {
        return this.serviceProvider.getEmitterController();
    }

    @Override
    @NonNull
    public SubjectController getSubject() {
        return this.serviceProvider.getSubjectController();
    }

    @Override
    @NonNull
    public GdprController getGdpr() {
        return this.serviceProvider.getGdprController();
    }

    @Override
    @NonNull
    public GlobalContextsController getGlobalContexts() {
        return this.serviceProvider.getGlobalContextsController();
    }

    @NonNull
    public SessionControllerImpl getSessionController() {
        return this.serviceProvider.getSessionController();
    }

    @Override
    @Nullable
    public SessionController getSession() {
        SessionControllerImpl sessionController = this.getSessionController();
        return sessionController.isEnabled() ? sessionController : null;
    }

    @Override
    public void pause() {
        this.getDirtyConfig().isPaused = true;
        this.getTracker().pauseEventTracking();
    }

    @Override
    public void resume() {
        this.getDirtyConfig().isPaused = false;
        this.getTracker().resumeEventTracking();
    }

    @Override
    public void track(@NonNull Event event) {
        this.getTracker().track(event);
    }

    @Override
    @NonNull
    public String getVersion() {
        return "andr-3.1.1";
    }

    @Override
    public boolean isTracking() {
        return this.getTracker().getDataCollection();
    }

    @Override
    @NonNull
    public String getNamespace() {
        return this.getTracker().namespace;
    }

    @Override
    @NonNull
    public String getAppId() {
        return this.getTracker().appId;
    }

    @Override
    public void setAppId(@NonNull String appId) {
        this.getDirtyConfig().appId = appId;
        this.getDirtyConfig().appIdUpdated = true;
        this.getTracker().appId = appId;
    }

    @Override
    @NonNull
    public DevicePlatform getDevicePlatform() {
        return this.getTracker().devicePlatform;
    }

    @Override
    public void setDevicePlatform(@NonNull DevicePlatform devicePlatform) {
        this.getDirtyConfig().devicePlatform = devicePlatform;
        this.getDirtyConfig().devicePlatformUpdated = true;
        this.getTracker().devicePlatform = devicePlatform;
    }

    @Override
    public boolean isBase64encoding() {
        return this.getTracker().base64Encoded;
    }

    @Override
    public void setBase64encoding(boolean base64encoding) {
        this.getDirtyConfig().base64encoding = base64encoding;
        this.getDirtyConfig().base64encodingUpdated = true;
        this.getTracker().base64Encoded = base64encoding;
    }

    @Override
    @NonNull
    public LogLevel getLogLevel() {
        return this.getTracker().level;
    }

    @Override
    public void setLogLevel(@NonNull LogLevel logLevel) {
        this.getDirtyConfig().logLevel = logLevel;
        this.getDirtyConfig().logLevelUpdated = true;
        this.getTracker().level = logLevel;
    }

    @Override
    @Nullable
    public LoggerDelegate getLoggerDelegate() {
        return Logger.getDelegate();
    }

    @Override
    public void setLoggerDelegate(@Nullable LoggerDelegate loggerDelegate) {
        this.getDirtyConfig().loggerDelegate = loggerDelegate;
        this.getDirtyConfig().loggerDelegateUpdated = true;
        Logger.setDelegate(loggerDelegate);
    }

    @Override
    public boolean isApplicationContext() {
        return this.getTracker().applicationContext;
    }

    @Override
    public void setApplicationContext(boolean applicationContext) {
        this.getDirtyConfig().applicationContext = applicationContext;
        this.getDirtyConfig().applicationContextUpdated = true;
        this.getTracker().applicationContext = applicationContext;
    }

    @Override
    public boolean isPlatformContext() {
        return this.getTracker().mobileContext;
    }

    @Override
    public void setPlatformContext(boolean platformContext) {
        this.getDirtyConfig().platformContext = platformContext;
        this.getDirtyConfig().platformContextUpdated = true;
        this.getTracker().mobileContext = platformContext;
    }

    @Override
    public boolean isGeoLocationContext() {
        return this.getTracker().geoLocationContext;
    }

    @Override
    public void setGeoLocationContext(boolean geoLocationContext) {
        this.getDirtyConfig().geoLocationContext = geoLocationContext;
        this.getDirtyConfig().geoLocationContextUpdated = true;
        this.getTracker().geoLocationContext = geoLocationContext;
    }

    @Override
    public boolean isSessionContext() {
        return this.getTracker().getSessionContext();
    }

    @Override
    public void setSessionContext(boolean sessionContext) {
        this.getDirtyConfig().sessionContext = sessionContext;
        this.getDirtyConfig().sessionContextUpdated = true;
        this.getTracker().setSessionContext(sessionContext);
    }

    @Override
    public boolean isDeepLinkContext() {
        return this.getTracker().getDeepLinkContext();
    }

    @Override
    public void setDeepLinkContext(boolean deepLinkContext) {
        this.getDirtyConfig().deepLinkContext = deepLinkContext;
        this.getDirtyConfig().deepLinkContextUpdated = true;
        this.getTracker().setDeepLinkContext(deepLinkContext);
    }

    @Override
    public boolean isScreenContext() {
        return this.getTracker().getScreenContext();
    }

    @Override
    public void setScreenContext(boolean screenContext) {
        this.getDirtyConfig().screenContext = screenContext;
        this.getDirtyConfig().screenContextUpdated = true;
        this.getTracker().setScreenContext(screenContext);
    }

    @Override
    public boolean isScreenViewAutotracking() {
        return this.getTracker().activityTracking;
    }

    @Override
    public void setScreenViewAutotracking(boolean screenViewAutotracking) {
        this.getDirtyConfig().screenViewAutotracking = screenViewAutotracking;
        this.getDirtyConfig().screenViewAutotrackingUpdated = true;
        this.getTracker().activityTracking = screenViewAutotracking;
    }

    @Override
    public boolean isLifecycleAutotracking() {
        return this.getTracker().lifecycleEvents;
    }

    @Override
    public void setLifecycleAutotracking(boolean lifecycleAutotracking) {
        this.getDirtyConfig().lifecycleAutotracking = lifecycleAutotracking;
        this.getDirtyConfig().lifecycleAutotrackingUpdated = true;
        this.getTracker().lifecycleEvents = lifecycleAutotracking;
    }

    @Override
    public boolean isInstallAutotracking() {
        return this.getTracker().installTracking;
    }

    @Override
    public void setInstallAutotracking(boolean installAutotracking) {
        this.getDirtyConfig().installAutotracking = installAutotracking;
        this.getDirtyConfig().installAutotrackingUpdated = true;
        this.getTracker().installTracking = installAutotracking;
    }

    @Override
    public boolean isExceptionAutotracking() {
        return this.getTracker().applicationCrash;
    }

    @Override
    public void setExceptionAutotracking(boolean exceptionAutotracking) {
        this.getDirtyConfig().exceptionAutotracking = exceptionAutotracking;
        this.getDirtyConfig().exceptionAutotrackingUpdated = true;
        this.getTracker().applicationCrash = exceptionAutotracking;
    }

    @Override
    public boolean isDiagnosticAutotracking() {
        return this.getTracker().trackerDiagnostic;
    }

    @Override
    public void setDiagnosticAutotracking(boolean diagnosticAutotracking) {
        this.getDirtyConfig().diagnosticAutotracking = diagnosticAutotracking;
        this.getDirtyConfig().diagnosticAutotrackingUpdated = true;
        this.getTracker().trackerDiagnostic = diagnosticAutotracking;
    }

    @Override
    @Nullable
    public String getTrackerVersionSuffix() {
        return this.getTracker().trackerVersionSuffix;
    }

    @Override
    public void setTrackerVersionSuffix(@Nullable String trackerVersionSuffix) {
    }

    @NonNull
    private Tracker getTracker() {
        return this.serviceProvider.getTracker();
    }

    @NonNull
    private TrackerConfigurationUpdate getDirtyConfig() {
        return this.serviceProvider.getTrackerConfigurationUpdate();
    }
}

