/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.event.AbstractPrimitive;
import com.snowplowanalytics.snowplow.event.AbstractSelfDescribing;
import com.snowplowanalytics.snowplow.event.Event;
import com.snowplowanalytics.snowplow.event.TrackerError;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerState;
import com.snowplowanalytics.snowplow.internal.tracker.TrackerStateSnapshot;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.InspectableEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class TrackerEvent
implements InspectableEvent {
    Map<String, Object> payload;
    String schema;
    String eventName;
    UUID eventId = UUID.randomUUID();
    long timestamp = System.currentTimeMillis();
    Long trueTimestamp;
    List<SelfDescribingJson> contexts;
    TrackerStateSnapshot state;
    boolean isPrimitive;
    boolean isService;

    public TrackerEvent(@NonNull Event event) {
        this(event, null);
    }

    public TrackerEvent(@NonNull Event event, @Nullable TrackerStateSnapshot state) {
        this.contexts = new ArrayList<SelfDescribingJson>(event.getContexts());
        this.trueTimestamp = event.getTrueTimestamp();
        this.payload = new HashMap<String, Object>(event.getDataPayload());
        this.state = state != null ? state : new TrackerState();
        this.isService = event instanceof TrackerError;
        if (event instanceof AbstractPrimitive) {
            this.eventName = ((AbstractPrimitive)event).getName();
            this.isPrimitive = true;
        } else {
            this.schema = ((AbstractSelfDescribing)event).getSchema();
            this.isPrimitive = false;
        }
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    public String getName() {
        return this.eventName;
    }

    @Override
    @NonNull
    public Map<String, Object> getPayload() {
        return this.payload;
    }

    @Override
    @NonNull
    public TrackerStateSnapshot getState() {
        return this.state;
    }

    @Override
    public boolean addPayloadValues(@NonNull Map<String, Object> payloadAdding) {
        boolean result = true;
        for (Map.Entry<String, Object> entry : payloadAdding.entrySet()) {
            String key = entry.getKey();
            if (this.payload.get(key) == null) {
                this.payload.put(key, entry.getValue());
                continue;
            }
            result = false;
        }
        return result;
    }
}

