/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.telephony.TelephonyManager;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.configuration.TrackerConfiguration;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import java.lang.reflect.Method;

public class DeviceInfoMonitor {
    @NonNull
    public String getOsType() {
        return "android";
    }

    @NonNull
    public String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    @NonNull
    public String getDeviceModel() {
        return Build.MODEL;
    }

    @NonNull
    public String getDeviceVendor() {
        return Build.MANUFACTURER;
    }

    @Nullable
    public String getCarrier(@NonNull Context context) {
        String carrierName;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null && !(carrierName = telephonyManager.getNetworkOperatorName()).equals("")) {
            return carrierName;
        }
        return null;
    }

    @Nullable
    public String getAndroidIdfa(@NonNull Context context) {
        try {
            Object advertisingInfoObject = DeviceInfoMonitor.invokeStaticMethod("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", new Class[]{Context.class}, context);
            Boolean limitedTracking = (Boolean)DeviceInfoMonitor.invokeInstanceMethod(advertisingInfoObject, "isLimitAdTrackingEnabled", null, new Object[0]);
            if (limitedTracking.booleanValue()) {
                return "";
            }
            return (String)DeviceInfoMonitor.invokeInstanceMethod(advertisingInfoObject, "getId", null, new Object[0]);
        }
        catch (Exception e) {
            Logger.e(TrackerConfiguration.TAG, "Exception getting the Advertising ID: %s", e.toString());
            return null;
        }
    }

    @NonNull
    public String getNetworkType(@Nullable NetworkInfo networkInfo) {
        String networkType = "offline";
        if (networkInfo != null) {
            String maybeNetworkType;
            switch (maybeNetworkType = networkInfo.getTypeName().toLowerCase()) {
                case "mobile": 
                case "wifi": {
                    networkType = maybeNetworkType;
                    break;
                }
            }
        }
        return networkType;
    }

    @Nullable
    public String getNetworkTechnology(@Nullable NetworkInfo networkInfo) {
        String networkType;
        String networkTech = null;
        if (networkInfo != null && (networkType = networkInfo.getTypeName()).equalsIgnoreCase("MOBILE")) {
            networkTech = networkInfo.getSubtypeName();
        }
        return networkTech;
    }

    @Nullable
    public NetworkInfo getNetworkInfo(@NonNull Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo ni = null;
        try {
            NetworkInfo maybeNi = cm.getActiveNetworkInfo();
            if (maybeNi != null && maybeNi.isConnected()) {
                ni = maybeNi;
            }
        }
        catch (SecurityException e) {
            Logger.e(TrackerConfiguration.TAG, "Security exception getting NetworkInfo: %s", e.toString());
        }
        return ni;
    }

    public long getPhysicalMemory(@NonNull Context context) {
        ActivityManager.MemoryInfo mi = this.getMemoryInfo(context);
        return mi.totalMem;
    }

    public long getSystemAvailableMemory(@NonNull Context context) {
        ActivityManager.MemoryInfo mi = this.getMemoryInfo(context);
        return mi.availMem;
    }

    @Nullable
    public Pair<String, Integer> getBatteryStateAndLevel(@NonNull Context context) {
        String batteryState;
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryIntent = context.registerReceiver(null, ifilter);
        if (batteryIntent == null) {
            return null;
        }
        int status = batteryIntent.getIntExtra("status", -1);
        int level = batteryIntent.getIntExtra("level", -1);
        int scale = batteryIntent.getIntExtra("scale", -1);
        if (status == -1 || level == -1 || scale == -1) {
            return null;
        }
        switch (status) {
            case 1: {
                batteryState = null;
                break;
            }
            case 5: {
                batteryState = "full";
                break;
            }
            case 2: {
                batteryState = "charging";
                break;
            }
            default: {
                batteryState = "unplugged";
            }
        }
        int batteryLevel = (int)((float)(level * 100) / (float)scale);
        return new Pair((Object)batteryState, (Object)batteryLevel);
    }

    public long getAvailableStorage() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return statFs.getFreeBytes();
    }

    public long getTotalStorage() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        return statFs.getTotalBytes();
    }

    @NonNull
    private ActivityManager.MemoryInfo getMemoryInfo(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(mi);
        return mi;
    }

    private static Object invokeInstanceMethod(Object instance, String methodName, Class[] cArgs, Object ... args) throws Exception {
        Class<?> classObject = instance.getClass();
        return DeviceInfoMonitor.invokeMethod(classObject, methodName, instance, cArgs, args);
    }

    private static Object invokeStaticMethod(String className, String methodName, Class[] cArgs, Object ... args) throws Exception {
        Class<?> classObject = Class.forName(className);
        return DeviceInfoMonitor.invokeMethod(classObject, methodName, null, cArgs, args);
    }

    private static Object invokeMethod(Class classObject, String methodName, Object instance, Class[] cArgs, Object ... args) throws Exception {
        Method methodObject = classObject.getMethod(methodName, cArgs);
        return methodObject.invoke(instance, args);
    }
}

