/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.utils;

import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class NotificationCenter {
    @NonNull
    private static final Map<String, List<WeakObserver>> notificationMap = new HashMap<String, List<WeakObserver>>();
    private static final WeakHashMap<FunctionalObserver, WeakObserver> observerMap = new WeakHashMap();

    public static synchronized void addObserver(@NonNull String notificationType, @NonNull FunctionalObserver observer) {
        List<WeakObserver> observers;
        WeakObserver weakObserver = new WeakObserver(observer);
        WeakObserver previousObserver = observerMap.put(observer, weakObserver);
        if (previousObserver != null) {
            previousObserver.invalidate();
        }
        if ((observers = notificationMap.get(notificationType)) == null) {
            observers = new LinkedList<WeakObserver>();
            notificationMap.put(notificationType, observers);
        }
        observers.add(weakObserver);
    }

    public static synchronized boolean removeObserver(@NonNull FunctionalObserver observer) {
        WeakObserver weakObserver = observerMap.remove(observer);
        if (weakObserver != null) {
            weakObserver.invalidate();
            return true;
        }
        return false;
    }

    public static synchronized void removeAll() {
        observerMap.clear();
        notificationMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static synchronized boolean postNotification(@NonNull String notificationType, @NonNull Map<String, Object> data) {
        List<WeakObserver> observers = notificationMap.get(notificationType);
        if (observers == null) return false;
        if (observers.isEmpty()) {
            return false;
        }
        Iterator<WeakObserver> iterator = observers.iterator();
        while (iterator.hasNext()) {
            WeakObserver weakObserver = iterator.next();
            if (!weakObserver.isValid()) {
                Class<NotificationCenter> clazz = NotificationCenter.class;
                // MONITORENTER : com.snowplowanalytics.snowplow.internal.utils.NotificationCenter.class
                iterator.remove();
                // MONITOREXIT : clazz
                continue;
            }
            HashMap<String, Object> dataCopy = new HashMap<String, Object>(data);
            ((FunctionalObserver)weakObserver.get()).apply(dataCopy);
        }
        if (observers.isEmpty()) return false;
        return true;
    }

    private static class WeakObserver
    extends WeakReference<FunctionalObserver> {
        private boolean valid = true;

        public WeakObserver(FunctionalObserver referent) {
            super(referent);
        }

        public synchronized boolean isValid() {
            return this.valid && this.get() != null;
        }

        public synchronized void invalidate() {
            this.valid = false;
            this.clear();
        }
    }

    public static abstract class FunctionalObserver {
        public abstract void apply(@NonNull Map<String, Object> var1);
    }
}

