/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.internal.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Util {
    private static final String TAG = Util.class.getSimpleName();

    @NonNull
    public static String getTimestamp() {
        return Long.toString(System.currentTimeMillis());
    }

    @NonNull
    public static String base64Encode(@NonNull String string) {
        return Base64.encodeToString((byte[])string.getBytes(), (int)2);
    }

    @NonNull
    public static String getUUIDString() {
        return UUID.randomUUID().toString();
    }

    public static long getUTF8Length(@NonNull String s) {
        long len = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char code = s.charAt(i);
            if (code <= '\u007f') {
                ++len;
                continue;
            }
            if (code <= '\u07ff') {
                len += 2L;
                continue;
            }
            if (code >= '\ud800' && code <= '\udfff') {
                len += 4L;
                ++i;
                continue;
            }
            if (code < '\uffff') {
                len += 3L;
                continue;
            }
            len += 4L;
        }
        return len;
    }

    public static boolean isOnline(@NonNull Context context) {
        Logger.v(TAG, "Checking tracker internet connectivity.", new Object[0]);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            NetworkInfo ni = cm.getActiveNetworkInfo();
            boolean connected = ni != null && ni.isConnected();
            Logger.d(TAG, "Tracker connection online: %s", connected);
            return connected;
        }
        catch (SecurityException e) {
            Logger.e(TAG, "Security exception checking connection: %s", e.toString());
            return true;
        }
    }

    @NonNull
    public static String joinLongList(@NonNull List<Long> list) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Long longVal = list.get(i);
            if (longVal == null) continue;
            s.append(list.get(i));
            if (i >= list.size() - 1) continue;
            s.append(",");
        }
        if (s.toString().endsWith(",")) {
            s = new StringBuilder(s.substring(0, s.length() - 1));
        }
        return s.toString();
    }

    @Nullable
    public static SelfDescribingJson getGeoLocationContext(@NonNull Context context) {
        Location location = Util.getLastKnownLocation(context);
        if (location != null) {
            HashMap<String, Object> pairs = new HashMap<String, Object>();
            Util.addToMap("latitude", location.getLatitude(), pairs);
            Util.addToMap("longitude", location.getLongitude(), pairs);
            Util.addToMap("altitude", location.getAltitude(), pairs);
            Util.addToMap("latitudeLongitudeAccuracy", Float.valueOf(location.getAccuracy()), pairs);
            Util.addToMap("speed", Float.valueOf(location.getSpeed()), pairs);
            Util.addToMap("bearing", Float.valueOf(location.getBearing()), pairs);
            Util.addToMap("timestamp", System.currentTimeMillis(), pairs);
            if (Util.mapHasKeys(pairs, "latitude", "longitude")) {
                return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/geolocation_context/jsonschema/1-1-0", pairs);
            }
        }
        return null;
    }

    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public static Location getLastKnownLocation(@NonNull Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        Location location = null;
        try {
            String locationProvider = null;
            if (locationManager.isProviderEnabled("gps")) {
                locationProvider = "gps";
            } else if (locationManager.isProviderEnabled("network")) {
                locationProvider = "network";
            } else {
                List locationProviders = locationManager.getProviders(true);
                if (locationProviders.size() > 0) {
                    locationProvider = (String)locationProviders.get(0);
                }
            }
            if (locationProvider != null && !locationProvider.equals("")) {
                location = locationManager.getLastKnownLocation(locationProvider);
            }
        }
        catch (SecurityException ex) {
            Logger.e(TAG, "Exception occurred when retrieving location: %s", ex.toString());
        }
        return location;
    }

    @Nullable
    public static SelfDescribingJson getApplicationContext(@NonNull Context context) {
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = pInfo.versionName;
            String versionCode = Build.VERSION.SDK_INT >= 28 ? String.valueOf(pInfo.getLongVersionCode()) : String.valueOf(pInfo.versionCode);
            if (versionName != null) {
                HashMap<String, Object> pairs = new HashMap<String, Object>();
                Util.addToMap("version", versionName, pairs);
                Util.addToMap("build", versionCode, pairs);
                return new SelfDescribingJson("iglu:com.snowplowanalytics.mobile/application/jsonschema/1-0-0", pairs);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Failed to find application context: %s", e.getMessage());
        }
        return null;
    }

    public static boolean mapHasKeys(@NonNull Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            if (map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static void addToMap(@Nullable String key, @Nullable Object value, @NonNull Map<String, Object> map) {
        if (key != null && value != null && !key.isEmpty()) {
            map.put(key, value);
        }
    }

    @Nullable
    public static byte[] serialize(@NonNull Map<String, String> map) {
        byte[] newByteArray = null;
        try {
            ByteArrayOutputStream mem_out = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(mem_out);
            out.writeObject(map);
            out.close();
            mem_out.close();
            newByteArray = mem_out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newByteArray;
    }

    @Nullable
    public static Map<String, String> deserializer(@NonNull byte[] bytes) {
        HashMap newMap = null;
        try {
            ByteArrayInputStream mem_in = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(mem_in);
            HashMap map = (HashMap)in.readObject();
            in.close();
            mem_in.close();
            newMap = map;
        }
        catch (IOException | ClassNotFoundException | NullPointerException e) {
            e.printStackTrace();
        }
        return newMap;
    }

    @NonNull
    public static String stackTraceToString(@NonNull Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

