/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.network;

import android.net.TrafficStats;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.emitter.Executor;
import com.snowplowanalytics.snowplow.internal.emitter.TLSArguments;
import com.snowplowanalytics.snowplow.internal.emitter.TLSVersion;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.network.HttpMethod;
import com.snowplowanalytics.snowplow.network.NetworkConnection;
import com.snowplowanalytics.snowplow.network.Protocol;
import com.snowplowanalytics.snowplow.network.Request;
import com.snowplowanalytics.snowplow.network.RequestResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpNetworkConnection
implements NetworkConnection {
    private final String TAG = OkHttpNetworkConnection.class.getSimpleName();
    private static final int TRAFFIC_STATS_TAG = 1;
    private static final String DEFAULT_USER_AGENT = String.format("snowplow/%s android/%s", "andr-3.1.1", Build.VERSION.RELEASE);
    private final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final String uri;
    private final Protocol protocol;
    private final HttpMethod httpMethod;
    private final int emitTimeout;
    private final String customPostPath;
    private OkHttpClient client;
    private Uri.Builder uriBuilder;

    private OkHttpNetworkConnection(OkHttpNetworkConnectionBuilder builder) {
        String tempUri = builder.uri;
        Uri url = Uri.parse((String)builder.uri);
        Protocol tempProtocol = Protocol.HTTPS;
        if (url.getScheme() == null) {
            tempUri = "https://" + builder.uri;
        } else {
            switch (url.getScheme()) {
                case "https": {
                    break;
                }
                case "http": {
                    tempProtocol = Protocol.HTTP;
                    break;
                }
                default: {
                    tempUri = "https://" + builder.uri;
                }
            }
        }
        this.uri = tempUri;
        this.protocol = tempProtocol;
        this.httpMethod = builder.httpMethod;
        this.emitTimeout = builder.emitTimeout;
        this.customPostPath = builder.customPostPath;
        TLSArguments tlsArguments = new TLSArguments(builder.tlsVersions);
        String protocolString = this.protocol == Protocol.HTTP ? "http://" : "https://";
        this.uriBuilder = Uri.parse((String)this.uri).buildUpon();
        if (this.httpMethod == HttpMethod.GET) {
            this.uriBuilder.appendPath("i");
        } else if (this.customPostPath == null) {
            this.uriBuilder.appendEncodedPath("com.snowplowanalytics.snowplow/tp2");
        } else {
            this.uriBuilder.appendEncodedPath(this.customPostPath);
        }
        this.client = builder.client == null ? new OkHttpClient.Builder().sslSocketFactory(tlsArguments.getSslSocketFactory(), tlsArguments.getTrustManager()).connectTimeout(15L, TimeUnit.SECONDS).readTimeout(15L, TimeUnit.SECONDS).build() : builder.client;
    }

    @Override
    @NonNull
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    @NonNull
    public Uri getUri() {
        return this.uriBuilder.clearQuery().build();
    }

    @Override
    @NonNull
    public List<RequestResult> sendRequests(@NonNull List<Request> requests) {
        ArrayList futures = new ArrayList();
        ArrayList<RequestResult> results = new ArrayList<RequestResult>();
        for (Request request : requests) {
            String userAgent = request.customUserAgent != null ? request.customUserAgent : DEFAULT_USER_AGENT;
            okhttp3.Request okHttpRequest = this.httpMethod == HttpMethod.GET ? this.buildGetRequest(request, userAgent) : this.buildPostRequest(request, userAgent);
            futures.add(Executor.futureCallable(this.getRequestCallable(okHttpRequest)));
        }
        Logger.d(this.TAG, "Request Futures: %s", futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            int code = -1;
            try {
                code = (Integer)((Future)futures.get(i)).get(this.emitTimeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Logger.e(this.TAG, "Request Future was interrupted: %s", ie.getMessage());
            }
            catch (ExecutionException ee) {
                Logger.e(this.TAG, "Request Future failed: %s", ee.getMessage());
            }
            catch (TimeoutException te) {
                Logger.e(this.TAG, "Request Future had a timeout: %s", te.getMessage());
            }
            Request request = requests.get(i);
            List<Long> eventIds = request.emitterEventIds;
            if (request.oversize) {
                Logger.track(this.TAG, "Request is oversized for emitter event IDs: %s", eventIds.toString());
                results.add(new RequestResult(true, eventIds));
                continue;
            }
            results.add(new RequestResult(this.isSuccessfulSend(code), eventIds));
        }
        return results;
    }

    private okhttp3.Request buildGetRequest(Request request, String userAgent) {
        this.uriBuilder.clearQuery();
        HashMap hashMap = (HashMap)request.payload.getMap();
        for (String key : hashMap.keySet()) {
            String value = (String)hashMap.get(key);
            this.uriBuilder.appendQueryParameter(key, value);
        }
        String reqUrl = this.uriBuilder.build().toString();
        return new Request.Builder().url(reqUrl).header("User-Agent", userAgent).get().build();
    }

    private okhttp3.Request buildPostRequest(Request request, String userAgent) {
        String reqUrl = this.uriBuilder.build().toString();
        RequestBody reqBody = RequestBody.create((MediaType)this.JSON, (String)request.payload.toString());
        return new Request.Builder().url(reqUrl).header("User-Agent", userAgent).post(reqBody).build();
    }

    private Callable<Integer> getRequestCallable(okhttp3.Request request) {
        return () -> this.requestSender(request);
    }

    private int requestSender(okhttp3.Request request) {
        try {
            Logger.v(this.TAG, "Sending request: %s", request);
            TrafficStats.setThreadStatsTag((int)1);
            Response resp = this.client.newCall(request).execute();
            int code = resp.code();
            resp.body().close();
            return code;
        }
        catch (IOException e) {
            Logger.e(this.TAG, "Request sending failed: %s", e.toString());
            return -1;
        }
    }

    private boolean isSuccessfulSend(int code) {
        return code >= 200 && code < 300;
    }

    public static class OkHttpNetworkConnectionBuilder {
        final String uri;
        HttpMethod httpMethod = HttpMethod.POST;
        EnumSet<TLSVersion> tlsVersions = EnumSet.of(TLSVersion.TLSv1_2);
        private int emitTimeout = 5;
        OkHttpClient client = null;
        String customPostPath = null;

        public OkHttpNetworkConnectionBuilder(@NonNull String uri) {
            this.uri = uri;
        }

        @NonNull
        public OkHttpNetworkConnectionBuilder method(@NonNull HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @NonNull
        public OkHttpNetworkConnectionBuilder tls(@NonNull TLSVersion version) {
            this.tlsVersions = EnumSet.of(version);
            return this;
        }

        @NonNull
        public OkHttpNetworkConnectionBuilder tls(@NonNull EnumSet<TLSVersion> versions) {
            this.tlsVersions = versions;
            return this;
        }

        @NonNull
        public OkHttpNetworkConnectionBuilder emitTimeout(int emitTimeout) {
            this.emitTimeout = emitTimeout;
            return this;
        }

        @NonNull
        public OkHttpNetworkConnectionBuilder client(@Nullable OkHttpClient client) {
            this.client = client;
            return this;
        }

        @NonNull
        public OkHttpNetworkConnectionBuilder customPostPath(@Nullable String customPostPath) {
            this.customPostPath = customPostPath;
            return this;
        }

        @NonNull
        public OkHttpNetworkConnection build() {
            return new OkHttpNetworkConnection(this);
        }
    }
}

