/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.network;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.payload.Payload;
import com.snowplowanalytics.snowplow.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request {
    public final Payload payload;
    public final List<Long> emitterEventIds;
    public final boolean oversize;
    public final String customUserAgent;

    public Request(@NonNull Payload payload, long id) {
        this(payload, id, false);
    }

    public Request(@NonNull Payload payload, long id, boolean oversize) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        this.emitterEventIds = ids;
        this.payload = payload;
        this.oversize = oversize;
        this.customUserAgent = this.getUserAgent(payload);
    }

    public Request(@NonNull List<Payload> payloads, @NonNull List<Long> emitterEventIds) {
        String tempUserAgent = null;
        ArrayList<Map> payloadData = new ArrayList<Map>();
        for (Payload payload : payloads) {
            payloadData.add(payload.getMap());
            tempUserAgent = this.getUserAgent(payload);
        }
        this.payload = new TrackerPayload();
        SelfDescribingJson payloadBundle = new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/payload_data/jsonschema/1-0-4", payloadData);
        this.payload.addMap(payloadBundle.getMap());
        this.emitterEventIds = emitterEventIds;
        this.customUserAgent = tempUserAgent;
        this.oversize = false;
    }

    @Nullable
    private String getUserAgent(@NonNull Payload payload) {
        HashMap hashMap = (HashMap)payload.getMap();
        return (String)hashMap.get("ua");
    }
}

