/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.payload;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.utils.Preconditions;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.TrackerPayload;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class SelfDescribingJson {
    private final String TAG = SelfDescribingJson.class.getSimpleName();
    private final HashMap<String, Object> payload = new HashMap();

    public SelfDescribingJson(@NonNull String schema) {
        this(schema, new HashMap());
    }

    public SelfDescribingJson(@NonNull String schema, @NonNull TrackerPayload data) {
        this.setSchema(schema);
        this.setData(data);
    }

    public SelfDescribingJson(@NonNull String schema, @NonNull SelfDescribingJson data) {
        this.setSchema(schema);
        this.setData(data);
    }

    public SelfDescribingJson(@NonNull String schema, @NonNull Object data) {
        this.setSchema(schema);
        this.setData(data);
    }

    @NonNull
    public SelfDescribingJson setSchema(@NonNull String schema) {
        Preconditions.checkNotNull(schema, "schema cannot be null");
        Preconditions.checkArgument(!schema.isEmpty(), "schema cannot be empty.");
        this.payload.put("schema", schema);
        return this;
    }

    @NonNull
    public SelfDescribingJson setData(@Nullable TrackerPayload trackerPayload) {
        if (trackerPayload == null) {
            return this;
        }
        this.payload.put("data", trackerPayload.getMap());
        return this;
    }

    @NonNull
    public SelfDescribingJson setData(@Nullable Object data) {
        if (data == null) {
            return this;
        }
        this.payload.put("data", data);
        return this;
    }

    @NonNull
    public SelfDescribingJson setData(@Nullable SelfDescribingJson selfDescribingJson) {
        if (selfDescribingJson == null) {
            return this;
        }
        this.payload.put("data", selfDescribingJson.getMap());
        return this;
    }

    @NonNull
    public Map<String, Object> getMap() {
        return this.payload;
    }

    @NonNull
    public String toString() {
        return new JSONObject(this.payload).toString();
    }

    public long getByteSize() {
        return Util.getUTF8Length(this.toString());
    }
}

