/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.payload;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.tracker.Logger;
import com.snowplowanalytics.snowplow.internal.utils.Util;
import com.snowplowanalytics.snowplow.payload.Payload;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class TrackerPayload
implements Payload {
    private final String TAG = TrackerPayload.class.getSimpleName();
    private final HashMap<String, Object> payload = new HashMap();

    @Override
    public void add(@NonNull String key, @Nullable String value) {
        if (value == null || value.isEmpty()) {
            Logger.v(this.TAG, "The keys value is empty, removing the key: %s", key);
            this.payload.remove(key);
            return;
        }
        Logger.v(this.TAG, "Adding new kv pair: " + key + "->%s", value);
        this.payload.put(key, value);
    }

    @Override
    public void add(@NonNull String key, @Nullable Object value) {
        if (value == null) {
            Logger.v(this.TAG, "The value is empty, removing the key: %s", key);
            this.payload.remove(key);
            return;
        }
        Logger.v(this.TAG, "Adding new kv pair: " + key + "->%s", value);
        this.payload.put(key, value);
    }

    @Override
    public void addMap(@NonNull Map<String, Object> map) {
        if (map == null) {
            Logger.v(this.TAG, "Map passed in is null, returning without adding map.", new Object[0]);
            return;
        }
        Logger.v(this.TAG, "Adding new map: %s", map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.add(key, value);
        }
    }

    @Override
    public void addMap(@NonNull Map map, @NonNull Boolean base64_encoded, @Nullable String type_encoded, @Nullable String type_no_encoded) {
        if (map == null) {
            Logger.v(this.TAG, "Map passed in is null, returning nothing.", new Object[0]);
            return;
        }
        String mapString = new JSONObject(map).toString();
        Logger.v(this.TAG, "Adding new map: %s", map);
        if (base64_encoded.booleanValue()) {
            this.add(type_encoded, Util.base64Encode(mapString));
        } else {
            this.add(type_no_encoded, mapString);
        }
    }

    @Override
    @NonNull
    public HashMap<String, Object> getMap() {
        return this.payload;
    }

    @Override
    @NonNull
    public String toString() {
        return new JSONObject(this.payload).toString();
    }

    @Override
    public long getByteSize() {
        return Util.getUTF8Length(this.toString());
    }
}

