/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.snowplowanalytics.snowplow.internal.tracker.State;
import java.util.HashMap;
import java.util.Map;

public class SessionState
implements State {
    @NonNull
    private final String firstEventId;
    @Nullable
    private final String previousSessionId;
    @NonNull
    private final String sessionId;
    private final int sessionIndex;
    @NonNull
    private final String storage;
    @NonNull
    private final String userId;
    @NonNull
    private Map<String, Object> sessionContext;

    public SessionState(@NonNull String firstEventId, @NonNull String currentSessionId, @Nullable String previousSessionId, int sessionIndex, @NonNull String userId, @NonNull String storage) {
        this.firstEventId = firstEventId;
        this.sessionId = currentSessionId;
        this.previousSessionId = previousSessionId;
        this.sessionIndex = sessionIndex;
        this.userId = userId;
        this.storage = storage;
        this.sessionContext = new HashMap<String, Object>();
        this.sessionContext.put("previousSessionId", previousSessionId);
        this.sessionContext.put("sessionId", this.sessionId);
        this.sessionContext.put("firstEventId", firstEventId);
        this.sessionContext.put("sessionIndex", sessionIndex);
        this.sessionContext.put("storageMechanism", storage);
        this.sessionContext.put("userId", userId);
    }

    @Nullable
    public static SessionState build(@NonNull Map<String, Object> storedState) {
        Object value = storedState.get("firstEventId");
        if (!(value instanceof String)) {
            return null;
        }
        String firstEventId = (String)value;
        value = storedState.get("sessionId");
        if (!(value instanceof String)) {
            return null;
        }
        String sessionId = (String)value;
        value = storedState.get("previousSessionId");
        if (!(value instanceof String)) {
            value = null;
        }
        String previousSessionId = (String)value;
        value = storedState.get("sessionIndex");
        if (!(value instanceof Integer)) {
            return null;
        }
        int sessionIndex = (Integer)value;
        value = storedState.get("userId");
        if (!(value instanceof String)) {
            return null;
        }
        String userId = (String)value;
        value = storedState.get("storageMechanism");
        if (!(value instanceof String)) {
            return null;
        }
        String storage = (String)value;
        return new SessionState(firstEventId, sessionId, previousSessionId, sessionIndex, userId, storage);
    }

    @NonNull
    public String getFirstEventId() {
        return this.firstEventId;
    }

    @Nullable
    public String getPreviousSessionId() {
        return this.previousSessionId;
    }

    @NonNull
    public String getSessionId() {
        return this.sessionId;
    }

    public int getSessionIndex() {
        return this.sessionIndex;
    }

    @NonNull
    public String getStorage() {
        return this.storage;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    @NonNull
    public Map<String, Object> getSessionValues() {
        return this.sessionContext;
    }
}

