/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker;

import com.snowplowanalytics.snowplow.tracker.Subject;
import com.snowplowanalytics.snowplow.tracker.Tracker;
import com.snowplowanalytics.snowplow.tracker.configuration.EmitterConfiguration;
import com.snowplowanalytics.snowplow.tracker.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.tracker.configuration.SubjectConfiguration;
import com.snowplowanalytics.snowplow.tracker.configuration.TrackerConfiguration;
import com.snowplowanalytics.snowplow.tracker.emitter.BatchEmitter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Snowplow {
    private static final Map<String, Tracker> trackers = new HashMap<String, Tracker>();
    private static Tracker defaultTracker;

    public static Set<String> getInstancedTrackerNamespaces() {
        return trackers.keySet();
    }

    public static Tracker getDefaultTracker() {
        return defaultTracker;
    }

    public static void setDefaultTracker(Tracker tracker) {
        if (!trackers.containsKey(tracker.getNamespace())) {
            Snowplow.registerTracker(tracker);
        }
        defaultTracker = tracker;
    }

    public static boolean setDefaultTracker(String namespace) {
        if (trackers.containsKey(namespace)) {
            defaultTracker = trackers.get(namespace);
            return true;
        }
        return false;
    }

    public static Tracker createTracker(TrackerConfiguration trackerConfig, NetworkConfiguration networkConfig, EmitterConfiguration emitterConfig, SubjectConfiguration subjectConfig) {
        Subject subject = null;
        if (subjectConfig != null) {
            subject = new Subject(subjectConfig);
        }
        BatchEmitter emitter = new BatchEmitter(networkConfig, emitterConfig);
        Tracker tracker = new Tracker(trackerConfig, emitter, subject);
        Snowplow.registerTracker(tracker);
        return tracker;
    }

    public static Tracker createTracker(String namespace, String appId, String collectorUrl) {
        TrackerConfiguration trackerConfig = new TrackerConfiguration(namespace, appId);
        NetworkConfiguration networkConfig = new NetworkConfiguration(collectorUrl);
        return Snowplow.createTracker(trackerConfig, networkConfig, new EmitterConfiguration(), null);
    }

    public static Tracker createTracker(TrackerConfiguration trackerConfig, NetworkConfiguration networkConfig, EmitterConfiguration emitterConfig) {
        return Snowplow.createTracker(trackerConfig, networkConfig, emitterConfig, null);
    }

    public static Tracker createTracker(TrackerConfiguration trackerConfig, NetworkConfiguration networkConfig) {
        return Snowplow.createTracker(trackerConfig, networkConfig, new EmitterConfiguration(), null);
    }

    public static Tracker createTracker(TrackerConfiguration trackerConfig, NetworkConfiguration networkConfig, SubjectConfiguration subjectConfig) {
        return Snowplow.createTracker(trackerConfig, networkConfig, new EmitterConfiguration(), subjectConfig);
    }

    public static void registerTracker(Tracker tracker) {
        String namespace = tracker.getNamespace();
        if (trackers.containsKey(namespace)) {
            throw new IllegalArgumentException("Tracker with this namespace already exists.");
        }
        trackers.put(namespace, tracker);
        if (defaultTracker == null) {
            defaultTracker = tracker;
        }
    }

    public static Tracker getTracker(String namespace) {
        return trackers.get(namespace);
    }

    public static boolean removeTracker(String namespace) {
        Tracker removedTracker = trackers.remove(namespace);
        if (defaultTracker != null && defaultTracker.getNamespace().equals(namespace)) {
            defaultTracker = null;
        }
        return removedTracker != null;
    }

    public static boolean removeTracker(Tracker tracker) {
        return Snowplow.removeTracker(tracker.getNamespace());
    }

    public static void reset() {
        trackers.clear();
        defaultTracker = null;
    }
}

