/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker;

import com.snowplowanalytics.snowplow.tracker.Utils;
import com.snowplowanalytics.snowplow.tracker.configuration.SubjectConfiguration;
import java.util.HashMap;
import java.util.Map;

public class Subject {
    private HashMap<String, String> standardPairs = new HashMap();

    public Subject(SubjectConfiguration subjectConfig) {
        this.setUserId(subjectConfig.getUserId());
        this.setScreenResolution(subjectConfig.getScreenResWidth(), subjectConfig.getScreenResHeight());
        this.setViewPort(subjectConfig.getViewPortWidth(), subjectConfig.getViewPortHeight());
        this.setColorDepth(subjectConfig.getColorDepth());
        this.setTimezone(subjectConfig.getTimezone());
        this.setLanguage(subjectConfig.getLanguage());
        this.setIpAddress(subjectConfig.getIpAddress());
        this.setUseragent(subjectConfig.getUseragent());
        this.setNetworkUserId(subjectConfig.getNetworkUserId());
        this.setDomainUserId(subjectConfig.getDomainUserId());
        this.setDomainSessionId(subjectConfig.getDomainSessionId());
    }

    public Subject() {
        this(new SubjectConfiguration());
    }

    public Subject(Subject subject) {
        this.standardPairs.putAll(subject.getSubject());
    }

    @Deprecated
    public static SubjectBuilder builder() {
        return new SubjectBuilder();
    }

    public void setUserId(String userId) {
        if (userId != null) {
            this.standardPairs.put("uid", userId);
        }
    }

    public void setScreenResolution(int width, int height) {
        if (width > 0 && height > 0) {
            String res = Integer.toString(width) + "x" + Integer.toString(height);
            this.standardPairs.put("res", res);
        }
    }

    public void setViewPort(int width, int height) {
        if (width > 0 && height > 0) {
            String res = Integer.toString(width) + "x" + Integer.toString(height);
            this.standardPairs.put("vp", res);
        }
    }

    public void setColorDepth(int depth) {
        if (depth > 0) {
            this.standardPairs.put("cd", Integer.toString(depth));
        }
    }

    public void setTimezone(String timezone) {
        if (timezone != null) {
            this.standardPairs.put("tz", timezone);
        }
    }

    public void setLanguage(String language) {
        if (language != null) {
            this.standardPairs.put("lang", language);
        }
    }

    public void setIpAddress(String ipAddress) {
        if (ipAddress != null) {
            this.standardPairs.put("ip", ipAddress);
        }
    }

    public void setUseragent(String useragent) {
        if (useragent != null) {
            this.standardPairs.put("ua", useragent);
        }
    }

    public void setDomainUserId(String domainUserId) {
        if (domainUserId != null) {
            this.standardPairs.put("duid", domainUserId);
        }
    }

    public void setDomainSessionId(String domainSessionId) {
        if (domainSessionId != null) {
            this.standardPairs.put("sid", domainSessionId);
        }
    }

    public void setNetworkUserId(String networkUserId) {
        if (networkUserId != null) {
            this.standardPairs.put("tnuid", networkUserId);
        }
    }

    public Map<String, String> getSubject() {
        return this.standardPairs;
    }

    @Deprecated
    public static class SubjectBuilder {
        private String userId;
        private int screenResWidth = 0;
        private int screenResHeight = 0;
        private int viewPortWidth = 0;
        private int viewPortHeight = 0;
        private int colorDepth = 0;
        private String timezone = Utils.getTimezone();
        private String language;
        private String ipAddress;
        private String useragent;
        private String networkUserId;
        private String domainUserId;
        private String domainSessionId;

        public SubjectBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public SubjectBuilder screenResolution(int width, int height) {
            this.screenResWidth = width;
            this.screenResHeight = height;
            return this;
        }

        public SubjectBuilder viewPort(int width, int height) {
            this.viewPortWidth = width;
            this.viewPortHeight = height;
            return this;
        }

        public SubjectBuilder colorDepth(int depth) {
            this.colorDepth = depth;
            return this;
        }

        public SubjectBuilder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public SubjectBuilder language(String language) {
            this.language = language;
            return this;
        }

        public SubjectBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public SubjectBuilder useragent(String useragent) {
            this.useragent = useragent;
            return this;
        }

        public SubjectBuilder networkUserId(String networkUserId) {
            this.networkUserId = networkUserId;
            return this;
        }

        public SubjectBuilder domainUserId(String domainUserId) {
            this.domainUserId = domainUserId;
            return this;
        }

        public SubjectBuilder domainSessionId(String domainSessionId) {
            this.domainSessionId = domainSessionId;
            return this;
        }

        public Subject build() {
            SubjectConfiguration subjectConfig = new SubjectConfiguration().userId(this.userId).screenResolution(this.screenResWidth, this.screenResHeight).viewPort(this.viewPortWidth, this.viewPortHeight).colorDepth(this.colorDepth).timezone(this.timezone).language(this.language).ipAddress(this.ipAddress).useragent(this.useragent).networkUserId(this.networkUserId).domainUserId(this.domainUserId).domainSessionId(this.domainSessionId);
            return new Subject(subjectConfig);
        }
    }
}

