/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker;

import com.snowplowanalytics.snowplow.tracker.DevicePlatform;
import com.snowplowanalytics.snowplow.tracker.Subject;
import com.snowplowanalytics.snowplow.tracker.configuration.TrackerConfiguration;
import com.snowplowanalytics.snowplow.tracker.emitter.Emitter;
import com.snowplowanalytics.snowplow.tracker.events.AbstractEvent;
import com.snowplowanalytics.snowplow.tracker.events.EcommerceTransaction;
import com.snowplowanalytics.snowplow.tracker.events.Event;
import com.snowplowanalytics.snowplow.tracker.events.ScreenView;
import com.snowplowanalytics.snowplow.tracker.events.SelfDescribing;
import com.snowplowanalytics.snowplow.tracker.events.Timing;
import com.snowplowanalytics.snowplow.tracker.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerParameters;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Tracker {
    private Emitter emitter;
    private Subject subject;
    private final TrackerParameters parameters;

    public Tracker(TrackerConfiguration trackerConfig, Emitter emitter, Subject subject) {
        Objects.requireNonNull(emitter);
        Objects.requireNonNull(trackerConfig.getNamespace());
        Objects.requireNonNull(trackerConfig.getAppId());
        if (trackerConfig.getNamespace().isEmpty()) {
            throw new IllegalArgumentException("namespace cannot be empty");
        }
        if (trackerConfig.getAppId().isEmpty()) {
            throw new IllegalArgumentException("appId cannot be empty");
        }
        this.parameters = new TrackerParameters(trackerConfig.getAppId(), trackerConfig.getPlatform(), trackerConfig.getNamespace(), "java-1.0.1", trackerConfig.isBase64Encoded());
        this.emitter = emitter;
        this.subject = subject;
    }

    public Tracker(TrackerConfiguration trackerConfig, Emitter emitter) {
        this(trackerConfig, emitter, null);
    }

    @Deprecated
    public static TrackerBuilder builder(Emitter emitter, String namespace, String appId) {
        return new TrackerBuilder(emitter, namespace, appId);
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getTrackerVersion() {
        return this.parameters.getTrackerVersion();
    }

    public String getNamespace() {
        return this.parameters.getNamespace();
    }

    public String getAppId() {
        return this.parameters.getAppId();
    }

    public boolean getBase64Encoded() {
        return this.parameters.getBase64Encoded();
    }

    public DevicePlatform getPlatform() {
        return this.parameters.getPlatform();
    }

    public TrackerParameters getParameters() {
        return this.parameters;
    }

    public List<String> track(Event event) {
        ArrayList<String> results = new ArrayList<String>();
        List<Event> processedEvents = this.eventTypeSpecificPreProcessing(event);
        for (Event processedEvent : processedEvents) {
            TrackerPayload payload = (TrackerPayload)processedEvent.getPayload();
            this.addTrackerParameters(payload);
            this.addContext(processedEvent, payload);
            this.addSubject(processedEvent, payload);
            boolean addedToBuffer = this.emitter.add(payload);
            if (addedToBuffer) {
                results.add(payload.getEventId());
                continue;
            }
            results.add(null);
        }
        return results;
    }

    private List<Event> eventTypeSpecificPreProcessing(Event event) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        Class<?> eventClass = event.getClass();
        if (eventClass.equals(SelfDescribing.class)) {
            SelfDescribing selfDescribing = (SelfDescribing)event;
            selfDescribing.setBase64Encode(this.parameters.getBase64Encoded());
            eventList.add(selfDescribing);
        } else if (eventClass.equals(EcommerceTransaction.class)) {
            EcommerceTransaction ecommerceTransaction = (EcommerceTransaction)event;
            eventList.add(ecommerceTransaction);
            eventList.addAll(ecommerceTransaction.getItems());
        } else if (eventClass.equals(Timing.class) || eventClass.equals(ScreenView.class)) {
            SelfDescribing selfDescribing = ((SelfDescribing.Builder)((SelfDescribing.Builder)((SelfDescribing.Builder)((AbstractEvent.Builder)SelfDescribing.builder().eventData((SelfDescribingJson)event.getPayload())).customContext(event.getContext())).trueTimestamp(event.getTrueTimestamp())).subject(event.getSubject())).build();
            selfDescribing.setBase64Encode(this.parameters.getBase64Encoded());
            eventList.add(selfDescribing);
        } else {
            eventList.add(event);
        }
        return eventList;
    }

    private void addTrackerParameters(TrackerPayload payload) {
        payload.add("p", this.parameters.getPlatform().toString());
        payload.add("aid", this.parameters.getAppId());
        payload.add("tna", this.parameters.getNamespace());
        payload.add("tv", this.parameters.getTrackerVersion());
    }

    private void addContext(Event event, TrackerPayload payload) {
        List<SelfDescribingJson> entities = event.getContext();
        if (entities != null && entities.size() > 0) {
            SelfDescribingJson envelope = this.getFinalContext(entities);
            payload.addMap(envelope.getMap(), this.parameters.getBase64Encoded(), "cx", "co");
        }
    }

    private SelfDescribingJson getFinalContext(List<SelfDescribingJson> entities) {
        LinkedList<Map<String, Object>> entityMaps = new LinkedList<Map<String, Object>>();
        for (SelfDescribingJson selfDescribingJson : entities) {
            entityMaps.add(selfDescribingJson.getMap());
        }
        return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/contexts/jsonschema/1-0-1", entityMaps);
    }

    private void addSubject(Event event, TrackerPayload payload) {
        Subject eventSubject = event.getSubject();
        if (eventSubject != null) {
            payload.addMap(new HashMap<String, String>(eventSubject.getSubject()));
        } else if (this.subject != null) {
            payload.addMap(new HashMap<String, String>(this.subject.getSubject()));
        }
    }

    public void close() {
        this.emitter.close();
    }

    @Deprecated
    public static class TrackerBuilder {
        private final Emitter emitter;
        private final String namespace;
        private final String appId;
        private Subject subject = null;
        private DevicePlatform platform = DevicePlatform.ServerSideApp;
        private boolean base64Encoded = true;

        public TrackerBuilder(Emitter emitter, String namespace, String appId) {
            this.emitter = emitter;
            this.namespace = namespace;
            this.appId = appId;
        }

        public TrackerBuilder subject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public TrackerBuilder platform(DevicePlatform platform) {
            this.platform = platform;
            return this;
        }

        public TrackerBuilder base64(Boolean base64) {
            this.base64Encoded = base64;
            return this;
        }

        public Tracker build() {
            TrackerConfiguration trackerConfig = new TrackerConfiguration(this.namespace, this.appId).platform(this.platform).base64Encoded(this.base64Encoded);
            return new Tracker(trackerConfig, this.emitter, this.subject);
        }
    }
}

