/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String getTimestamp() {
        return Long.toString(System.currentTimeMillis());
    }

    public static String getEventId() {
        return UUID.randomUUID().toString();
    }

    public static int getTransactionId() {
        Random r = new Random();
        return r.nextInt(900000) + 100000;
    }

    public static boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Invalid URI");
            LOGGER.debug("URI {} is not valid: {}", (Object)url, (Object)e.getMessage());
            return false;
        }
    }

    public static String getTimezone() {
        TimeZone tz = Calendar.getInstance().getTimeZone();
        return tz.getID();
    }

    public static String base64Encode(String string, Charset charset) {
        return Base64.getEncoder().encodeToString(string.getBytes(charset));
    }

    public static String mapToJSONString(Map<String, ?> map) {
        String jString = "";
        try {
            jString = objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not process Map into JSON String");
            LOGGER.debug("Could not process Map {} into JSON String: {}", map, (Object)e.getMessage());
        }
        return jString;
    }

    public static String mapToQueryString(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (String key : map.keySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            String encodedKey = Utils.urlEncodeUTF8(key);
            String encodedVal = Utils.urlEncodeUTF8(map.get(key));
            if (encodedKey.isEmpty()) continue;
            sb.append(String.format("%s=%s", encodedKey, encodedVal));
        }
        return sb.toString();
    }

    public static String urlEncodeUTF8(Object o) {
        try {
            String s = (String)o;
            String encoded = URLEncoder.encode(s, "UTF-8");
            return encoded.replaceAll("\\+", "%20");
        }
        catch (Exception e) {
            LOGGER.error("Object could not be encoded");
            LOGGER.debug("Object {} could not be encoded: {}", o, (Object)e.getMessage());
            return "";
        }
    }

    public static long getUTF8Length(String s) {
        long len = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char code = s.charAt(i);
            if (code <= '\u007f') {
                ++len;
                continue;
            }
            if (code <= '\u07ff') {
                len += 2L;
                continue;
            }
            if (code >= '\ud800' && code <= '\udfff') {
                len += 4L;
                ++i;
                continue;
            }
            if (code < '\uffff') {
                len += 3L;
                continue;
            }
            len += 4L;
        }
        return len;
    }
}

