/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.emitter;

import com.snowplowanalytics.snowplow.tracker.configuration.EmitterConfiguration;
import com.snowplowanalytics.snowplow.tracker.configuration.NetworkConfiguration;
import com.snowplowanalytics.snowplow.tracker.emitter.BatchPayload;
import com.snowplowanalytics.snowplow.tracker.emitter.Emitter;
import com.snowplowanalytics.snowplow.tracker.emitter.EmitterCallback;
import com.snowplowanalytics.snowplow.tracker.emitter.EventStore;
import com.snowplowanalytics.snowplow.tracker.emitter.FailureType;
import com.snowplowanalytics.snowplow.tracker.emitter.InMemoryEventStore;
import com.snowplowanalytics.snowplow.tracker.http.HttpClientAdapter;
import com.snowplowanalytics.snowplow.tracker.http.OkHttpClientAdapter;
import com.snowplowanalytics.snowplow.tracker.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchEmitter
implements Emitter,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchEmitter.class);
    private boolean isClosing = false;
    private final AtomicInteger retryDelay;
    private final int maximumRetryDelay = 600000;
    private int batchSize;
    private final HttpClientAdapter httpClientAdapter;
    private final ScheduledExecutorService executor;
    private final EventStore eventStore;
    private final Map<Integer, Boolean> customRetryForStatusCodes;
    private final EmitterCallback callback;

    @Deprecated
    public static Builder<?> builder() {
        return new Builder2();
    }

    public BatchEmitter(NetworkConfiguration networkConfig, EmitterConfiguration emitterConfig) {
        if (emitterConfig.getThreadCount() <= 0) {
            throw new IllegalArgumentException("threadCount must be greater than 0");
        }
        if (emitterConfig.getBatchSize() <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        if (emitterConfig.getBufferCapacity() <= 0) {
            throw new IllegalArgumentException("bufferCapacity must be greater than 0");
        }
        if (networkConfig.getHttpClientAdapter() != null) {
            this.httpClientAdapter = networkConfig.getHttpClientAdapter();
        } else {
            Objects.requireNonNull(networkConfig.getCollectorUrl(), "Collector url must be specified if not using a httpClientAdapter");
            OkHttpClient client = networkConfig.getCookieJar() != null ? new OkHttpClient.Builder().cookieJar(networkConfig.getCookieJar()).build() : new OkHttpClient.Builder().build();
            this.httpClientAdapter = ((OkHttpClientAdapter.Builder)((OkHttpClientAdapter.Builder)OkHttpClientAdapter.builder().url(networkConfig.getCollectorUrl())).httpClient(client)).build();
        }
        this.retryDelay = new AtomicInteger(0);
        this.batchSize = emitterConfig.getBatchSize();
        this.callback = emitterConfig.getCallback() != null ? emitterConfig.getCallback() : new EmitterCallback(){

            @Override
            public void onSuccess(List<TrackerPayload> payloads) {
            }

            @Override
            public void onFailure(FailureType failureType, boolean willRetry, List<TrackerPayload> payloads) {
            }
        };
        this.eventStore = emitterConfig.getEventStore() != null ? emitterConfig.getEventStore() : new InMemoryEventStore(emitterConfig.getBufferCapacity());
        this.customRetryForStatusCodes = emitterConfig.getCustomRetryForStatusCodes() != null ? emitterConfig.getCustomRetryForStatusCodes() : new HashMap<Integer, Boolean>();
        this.executor = emitterConfig.getRequestExecutorService() != null ? emitterConfig.getRequestExecutorService() : Executors.newScheduledThreadPool(emitterConfig.getThreadCount(), new EmitterThreadFactory());
    }

    public BatchEmitter(NetworkConfiguration networkConfig) {
        this(networkConfig, new EmitterConfiguration());
    }

    @Override
    public boolean add(TrackerPayload payload) {
        boolean result = this.eventStore.addEvent(payload);
        if (!this.isClosing && this.eventStore.size() >= this.batchSize) {
            this.executor.schedule(this.getPostRequestRunnable(this.batchSize), (long)this.retryDelay.get(), TimeUnit.MILLISECONDS);
        }
        if (!result) {
            LOGGER.error("Unable to add payload to emitter, emitter buffer is full");
            this.callback.onFailure(FailureType.TRACKER_STORAGE_FULL, false, Collections.singletonList(payload));
        }
        return result;
    }

    @Override
    public void flushBuffer() {
        this.executor.schedule(this.getPostRequestRunnable(this.eventStore.size()), 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public List<TrackerPayload> getBuffer() {
        return this.eventStore.getAllEvents();
    }

    @Override
    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    int getRetryDelay() {
        return this.retryDelay.get();
    }

    protected boolean isSuccessfulSend(int code) {
        return code >= 200 && code < 300;
    }

    protected boolean shouldRetry(int code) {
        if (this.isSuccessfulSend(code)) {
            return false;
        }
        if (this.customRetryForStatusCodes.containsKey(code)) {
            return Objects.requireNonNull(this.customRetryForStatusCodes.get(code));
        }
        HashSet<Integer> dontRetryStatusCodes = new HashSet<Integer>(Arrays.asList(400, 401, 403, 410, 422));
        return !dontRetryStatusCodes.contains(code);
    }

    private Runnable getPostRequestRunnable(int numberOfEvents) {
        return () -> {
            block11: {
                BatchPayload batchedEvents = null;
                List<Object> eventsDeletedFromStorage = new ArrayList();
                try {
                    batchedEvents = this.eventStore.getEventsBatch(numberOfEvents);
                    if (batchedEvents == null || batchedEvents.size() == 0) {
                        return;
                    }
                    ArrayList<TrackerPayload> eventsInRequest = new ArrayList<TrackerPayload>(batchedEvents.getPayloads());
                    SelfDescribingJson post = this.getFinalPost(eventsInRequest);
                    int code = this.httpClientAdapter.post(post);
                    if (this.isSuccessfulSend(code)) {
                        LOGGER.debug("BatchEmitter successfully sent {} events: code: {}", (Object)eventsInRequest.size(), (Object)code);
                        this.retryDelay.set(0);
                        this.eventStore.cleanupAfterSendingAttempt(false, batchedEvents.getBatchId());
                        this.callback.onSuccess(eventsInRequest);
                    } else if (!this.shouldRetry(code)) {
                        LOGGER.debug("BatchEmitter failed to send {} events. No retry for code {}: events dropped", (Object)eventsInRequest.size(), (Object)code);
                        this.eventStore.cleanupAfterSendingAttempt(false, batchedEvents.getBatchId());
                        this.callback.onFailure(FailureType.REJECTED_BY_COLLECTOR, false, eventsInRequest);
                    } else {
                        LOGGER.error("BatchEmitter failed to send {} events: code: {}", (Object)eventsInRequest.size(), (Object)code);
                        eventsDeletedFromStorage = this.eventStore.cleanupAfterSendingAttempt(true, batchedEvents.getBatchId());
                        if (code == -1) {
                            this.callback.onFailure(FailureType.HTTP_CONNECTION_FAILURE, true, eventsInRequest);
                        } else {
                            this.callback.onFailure(FailureType.REJECTED_BY_COLLECTOR, true, eventsInRequest);
                        }
                        if (!eventsDeletedFromStorage.isEmpty()) {
                            this.callback.onFailure(FailureType.TRACKER_STORAGE_FULL, false, eventsDeletedFromStorage);
                        }
                        if (!this.retryDelay.compareAndSet(0, 100)) {
                            this.retryDelay.updateAndGet(this::calculateRetryDelay);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("BatchEmitter event sending error: {}", (Object)e.getMessage());
                    if (batchedEvents == null) break block11;
                    eventsDeletedFromStorage = this.eventStore.cleanupAfterSendingAttempt(true, batchedEvents.getBatchId());
                    this.callback.onFailure(FailureType.EMITTER_REQUEST_FAILURE, true, new ArrayList<TrackerPayload>(batchedEvents.getPayloads()));
                    if (eventsDeletedFromStorage.isEmpty()) break block11;
                    this.callback.onFailure(FailureType.TRACKER_STORAGE_FULL, false, eventsDeletedFromStorage);
                }
            }
        };
    }

    private SelfDescribingJson getFinalPost(List<TrackerPayload> events) {
        ArrayList<Map<String, String>> toSendPayloads = new ArrayList<Map<String, String>>();
        String sentTimestamp = Long.toString(System.currentTimeMillis());
        for (TrackerPayload payload : events) {
            payload.add("stm", sentTimestamp);
            toSendPayloads.add(payload.getMap());
        }
        return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/payload_data/jsonschema/1-0-4", toSendPayloads);
    }

    private int calculateRetryDelay(int currentDelay) {
        double newDelay;
        double jitter = Math.random();
        int randomChoice = Math.random() < 0.5 ? 0 : 1;
        switch (randomChoice) {
            case 0: {
                newDelay = (double)currentDelay * (2.0 + jitter);
                break;
            }
            case 1: {
                newDelay = (double)currentDelay * (2.0 - jitter);
                break;
            }
            default: {
                newDelay = currentDelay;
            }
        }
        return Math.min((int)newDelay, 600000);
    }

    @Override
    public void close() {
        long closeTimeout = 5L;
        this.isClosing = true;
        this.flushBuffer();
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                        LOGGER.warn("Emitter executor did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static class EmitterThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        EmitterThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "snowplow-emitter-pool-" + poolNumber.getAndIncrement() + "-request-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    @Deprecated
    public static abstract class Builder<T extends Builder<T>> {
        private HttpClientAdapter httpClientAdapter;
        private String collectorUrl = null;
        private int batchSize = 50;
        private int bufferCapacity = 10000;
        private EventStore eventStore = null;
        private Map<Integer, Boolean> customRetryForStatusCodes = null;
        private int threadCount = 50;
        private CookieJar cookieJar = null;
        private ScheduledExecutorService requestExecutorService = null;
        private EmitterCallback callback = null;

        protected abstract T self();

        public T httpClientAdapter(HttpClientAdapter httpClientAdapter) {
            this.httpClientAdapter = httpClientAdapter;
            return this.self();
        }

        public T url(String collectorUrl) {
            this.collectorUrl = collectorUrl;
            return this.self();
        }

        public T batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this.self();
        }

        public T bufferCapacity(int bufferCapacity) {
            this.bufferCapacity = bufferCapacity;
            return this.self();
        }

        public T eventStore(EventStore eventStore) {
            this.eventStore = eventStore;
            return this.self();
        }

        public T customRetryForStatusCodes(Map<Integer, Boolean> customRetryForStatusCodes) {
            this.customRetryForStatusCodes = customRetryForStatusCodes;
            return this.self();
        }

        public T threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this.self();
        }

        public T requestExecutorService(ScheduledExecutorService requestExecutorService) {
            this.requestExecutorService = requestExecutorService;
            return this.self();
        }

        public T cookieJar(CookieJar cookieJar) {
            this.cookieJar = cookieJar;
            return this.self();
        }

        public T callback(EmitterCallback callback) {
            this.callback = callback;
            return this.self();
        }

        public BatchEmitter build() {
            NetworkConfiguration networkConfig = new NetworkConfiguration(this.collectorUrl).httpClientAdapter(this.httpClientAdapter).cookieJar(this.cookieJar);
            EmitterConfiguration emitterConfig = new EmitterConfiguration().batchSize(this.batchSize).bufferCapacity(this.bufferCapacity).eventStore(this.eventStore).customRetryForStatusCodes(this.customRetryForStatusCodes).threadCount(this.threadCount).requestExecutorService(this.requestExecutorService).callback(this.callback);
            return new BatchEmitter(networkConfig, emitterConfig);
        }
    }
}

