/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.emitter;

import com.snowplowanalytics.snowplow.tracker.emitter.BatchPayload;
import com.snowplowanalytics.snowplow.tracker.emitter.EventStore;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryEventStore
implements EventStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryEventStore.class);
    private static final int DEFAULT_BUFFER_SIZE = 10000;
    private final AtomicLong batchId = new AtomicLong(1L);
    private final LinkedBlockingDeque<TrackerPayload> eventBuffer;
    private final ConcurrentHashMap<Long, List<TrackerPayload>> eventsBeingSent = new ConcurrentHashMap();

    public InMemoryEventStore(int bufferCapacity) {
        this.eventBuffer = new LinkedBlockingDeque(bufferCapacity);
    }

    public InMemoryEventStore() {
        this(10000);
    }

    @Override
    public boolean addEvent(TrackerPayload trackerPayload) {
        return this.eventBuffer.offer(trackerPayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchPayload getEventsBatch(int numberToGet) {
        ArrayList<TrackerPayload> eventsToSend = new ArrayList<TrackerPayload>();
        LinkedBlockingDeque<TrackerPayload> linkedBlockingDeque = this.eventBuffer;
        synchronized (linkedBlockingDeque) {
            if (this.eventBuffer.size() < numberToGet) {
                return null;
            }
            this.eventBuffer.drainTo(eventsToSend, numberToGet);
        }
        BatchPayload batchedEvents = new BatchPayload(this.batchId.getAndIncrement(), eventsToSend);
        this.eventsBeingSent.put(batchedEvents.getBatchId(), batchedEvents.getPayloads());
        return batchedEvents;
    }

    @Override
    public List<TrackerPayload> cleanupAfterSendingAttempt(boolean needRetry, long batchId) {
        List<TrackerPayload> events = this.eventsBeingSent.remove(batchId);
        ArrayList<TrackerPayload> removedEvents = new ArrayList<TrackerPayload>();
        if (needRetry) {
            while (events.size() > 0) {
                TrackerPayload payloadToReinsert = events.remove(0);
                boolean result = this.eventBuffer.offerFirst(payloadToReinsert);
                if (result) continue;
                LOGGER.error("Event buffer is full. Dropping newer payload to reinsert older payload");
                removedEvents.add(this.eventBuffer.removeLast());
                this.eventBuffer.offerFirst(payloadToReinsert);
            }
        }
        return removedEvents;
    }

    @Override
    public List<TrackerPayload> getAllEvents() {
        TrackerPayload[] events = this.eventBuffer.toArray(new TrackerPayload[0]);
        return Arrays.asList(events);
    }

    @Override
    public int size() {
        return this.eventBuffer.size();
    }
}

