/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.events;

import com.snowplowanalytics.snowplow.tracker.Subject;
import com.snowplowanalytics.snowplow.tracker.events.Event;
import com.snowplowanalytics.snowplow.tracker.payload.Payload;
import com.snowplowanalytics.snowplow.tracker.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractEvent
implements Event {
    protected final List<SelfDescribingJson> context;
    protected Long trueTimestamp;
    protected final Subject subject;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected AbstractEvent(Builder<?> builder) {
        Objects.requireNonNull(((Builder)builder).context);
        this.context = ((Builder)builder).context;
        this.trueTimestamp = builder.trueTimestamp;
        this.subject = ((Builder)builder).subject;
    }

    @Override
    public List<SelfDescribingJson> getContext() {
        return new ArrayList<SelfDescribingJson>(this.context);
    }

    @Override
    public Long getTrueTimestamp() {
        return this.trueTimestamp;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public abstract Payload getPayload();

    protected TrackerPayload putTrueTimestamp(TrackerPayload payload) {
        if (this.getTrueTimestamp() != null) {
            payload.add("ttm", Long.toString(this.getTrueTimestamp()));
        }
        return payload;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private List<SelfDescribingJson> context = new LinkedList<SelfDescribingJson>();
        protected Long trueTimestamp = null;
        private Subject subject = null;

        protected abstract T self();

        public T customContext(List<SelfDescribingJson> context) {
            this.context = context;
            return this.self();
        }

        public T trueTimestamp(Long timestamp) {
            this.trueTimestamp = timestamp;
            return this.self();
        }

        public T subject(Subject subject) {
            this.subject = subject;
            return this.self();
        }
    }
}

