/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.events;

import com.snowplowanalytics.snowplow.tracker.events.AbstractEvent;
import com.snowplowanalytics.snowplow.tracker.events.EcommerceTransactionItem;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EcommerceTransaction
extends AbstractEvent {
    private final String orderId;
    private final Double totalValue;
    private final String affiliation;
    private final Double taxValue;
    private final Double shipping;
    private final String city;
    private final String state;
    private final String country;
    private final String currency;
    private final List<EcommerceTransactionItem> items;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected EcommerceTransaction(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).orderId);
        Objects.requireNonNull(((Builder)builder).totalValue);
        Objects.requireNonNull(((Builder)builder).items);
        if (((Builder)builder).orderId.isEmpty()) {
            throw new IllegalArgumentException("orderId cannot be empty");
        }
        this.orderId = ((Builder)builder).orderId;
        this.totalValue = ((Builder)builder).totalValue;
        this.affiliation = ((Builder)builder).affiliation;
        this.taxValue = ((Builder)builder).taxValue;
        this.shipping = ((Builder)builder).shipping;
        this.city = ((Builder)builder).city;
        this.state = ((Builder)builder).state;
        this.country = ((Builder)builder).country;
        this.currency = ((Builder)builder).currency;
        this.items = ((Builder)builder).items;
    }

    @Override
    public TrackerPayload getPayload() {
        TrackerPayload payload = new TrackerPayload();
        payload.add("e", "tr");
        payload.add("tr_id", this.orderId);
        payload.add("tr_tt", Double.toString(this.totalValue));
        payload.add("tr_af", this.affiliation);
        payload.add("tr_tx", this.taxValue != null ? Double.toString(this.taxValue) : null);
        payload.add("tr_sh", this.shipping != null ? Double.toString(this.shipping) : null);
        payload.add("tr_ci", this.city);
        payload.add("tr_st", this.state);
        payload.add("tr_co", this.country);
        payload.add("tr_cu", this.currency);
        return this.putTrueTimestamp(payload);
    }

    public List<EcommerceTransactionItem> getItems() {
        return this.items;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractEvent.Builder<T> {
        private String orderId;
        private Double totalValue;
        private String affiliation;
        private Double taxValue;
        private Double shipping;
        private String city;
        private String state;
        private String country;
        private String currency;
        private List<EcommerceTransactionItem> items;

        public T orderId(String orderId) {
            this.orderId = orderId;
            return (T)((Builder)this.self());
        }

        public T totalValue(Double totalValue) {
            this.totalValue = totalValue;
            return (T)((Builder)this.self());
        }

        public T affiliation(String affiliation) {
            this.affiliation = affiliation;
            return (T)((Builder)this.self());
        }

        public T taxValue(Double taxValue) {
            this.taxValue = taxValue;
            return (T)((Builder)this.self());
        }

        public T shipping(Double shipping) {
            this.shipping = shipping;
            return (T)((Builder)this.self());
        }

        public T city(String city) {
            this.city = city;
            return (T)((Builder)this.self());
        }

        public T state(String state) {
            this.state = state;
            return (T)((Builder)this.self());
        }

        public T country(String country) {
            this.country = country;
            return (T)((Builder)this.self());
        }

        public T currency(String currency) {
            this.currency = currency;
            return (T)((Builder)this.self());
        }

        public T items(List<EcommerceTransactionItem> items) {
            this.items = items;
            return (T)((Builder)this.self());
        }

        public T items(EcommerceTransactionItem ... itemArgs) {
            ArrayList<EcommerceTransactionItem> items = new ArrayList<EcommerceTransactionItem>();
            Collections.addAll(items, itemArgs);
            this.items = items;
            return (T)((Builder)this.self());
        }

        public EcommerceTransaction build() {
            return new EcommerceTransaction(this);
        }
    }
}

