/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.events;

import com.snowplowanalytics.snowplow.tracker.events.AbstractEvent;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.Objects;

public class EcommerceTransactionItem
extends AbstractEvent {
    private final String itemId;
    private final String sku;
    private final Double price;
    private final Integer quantity;
    private final String name;
    private final String category;
    private final String currency;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected EcommerceTransactionItem(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).itemId);
        Objects.requireNonNull(((Builder)builder).sku);
        Objects.requireNonNull(((Builder)builder).price);
        Objects.requireNonNull(((Builder)builder).quantity);
        if (((Builder)builder).itemId.isEmpty()) {
            throw new IllegalArgumentException("itemId cannot be empty");
        }
        if (((Builder)builder).sku.isEmpty()) {
            throw new IllegalArgumentException("sku cannot be empty");
        }
        this.itemId = ((Builder)builder).itemId;
        this.sku = ((Builder)builder).sku;
        this.price = ((Builder)builder).price;
        this.quantity = ((Builder)builder).quantity;
        this.name = ((Builder)builder).name;
        this.category = ((Builder)builder).category;
        this.currency = ((Builder)builder).currency;
    }

    @Override
    public TrackerPayload getPayload() {
        TrackerPayload payload = new TrackerPayload();
        payload.add("e", "ti");
        payload.add("ti_id", this.itemId);
        payload.add("ti_sk", this.sku);
        payload.add("ti_nm", this.name);
        payload.add("ti_ca", this.category);
        payload.add("ti_pr", Double.toString(this.price));
        payload.add("ti_qu", Integer.toString(this.quantity));
        payload.add("ti_cu", this.currency);
        return this.putTrueTimestamp(payload);
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractEvent.Builder<T> {
        private String itemId;
        private String sku;
        private Double price;
        private Integer quantity;
        private String name;
        private String category;
        private String currency;

        public T itemId(String itemId) {
            this.itemId = itemId;
            return (T)((Builder)this.self());
        }

        public T sku(String sku) {
            this.sku = sku;
            return (T)((Builder)this.self());
        }

        public T price(Double price) {
            this.price = price;
            return (T)((Builder)this.self());
        }

        public T quantity(Integer quantity) {
            this.quantity = quantity;
            return (T)((Builder)this.self());
        }

        public T name(String name) {
            this.name = name;
            return (T)((Builder)this.self());
        }

        public T category(String category) {
            this.category = category;
            return (T)((Builder)this.self());
        }

        public T currency(String currency) {
            this.currency = currency;
            return (T)((Builder)this.self());
        }

        public EcommerceTransactionItem build() {
            return new EcommerceTransactionItem(this);
        }
    }
}

