/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.events;

import com.snowplowanalytics.snowplow.tracker.events.AbstractEvent;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.Objects;

public class PageView
extends AbstractEvent {
    private final String pageUrl;
    private final String pageTitle;
    private final String referrer;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected PageView(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).pageUrl);
        if (((Builder)builder).pageUrl.isEmpty()) {
            throw new IllegalArgumentException("pageUrl cannot be empty");
        }
        this.pageUrl = ((Builder)builder).pageUrl;
        this.pageTitle = ((Builder)builder).pageTitle;
        this.referrer = ((Builder)builder).referrer;
    }

    @Override
    public TrackerPayload getPayload() {
        TrackerPayload payload = new TrackerPayload();
        payload.add("e", "pv");
        payload.add("url", this.pageUrl);
        payload.add("page", this.pageTitle);
        payload.add("refr", this.referrer);
        return this.putTrueTimestamp(payload);
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractEvent.Builder<T> {
        private String pageUrl;
        private String pageTitle;
        private String referrer;

        public T pageUrl(String pageUrl) {
            this.pageUrl = pageUrl;
            return (T)((Builder)this.self());
        }

        public T pageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
            return (T)((Builder)this.self());
        }

        public T referrer(String referrer) {
            this.referrer = referrer;
            return (T)((Builder)this.self());
        }

        public PageView build() {
            return new PageView(this);
        }
    }
}

