/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.events;

import com.snowplowanalytics.snowplow.tracker.events.AbstractEvent;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.Objects;

public class Structured
extends AbstractEvent {
    private final String category;
    private final String action;
    private final String label;
    private final String property;
    private final Double value;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected Structured(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).category);
        Objects.requireNonNull(((Builder)builder).action);
        if (((Builder)builder).category.isEmpty()) {
            throw new IllegalArgumentException("category cannot be empty");
        }
        if (((Builder)builder).action.isEmpty()) {
            throw new IllegalArgumentException("action cannot be empty");
        }
        this.category = ((Builder)builder).category;
        this.action = ((Builder)builder).action;
        this.label = ((Builder)builder).label;
        this.property = ((Builder)builder).property;
        this.value = ((Builder)builder).value;
    }

    @Override
    public TrackerPayload getPayload() {
        TrackerPayload payload = new TrackerPayload();
        payload.add("e", "se");
        payload.add("se_ca", this.category);
        payload.add("se_ac", this.action);
        payload.add("se_la", this.label);
        payload.add("se_pr", this.property);
        payload.add("se_va", this.value != null ? Double.toString(this.value) : null);
        return this.putTrueTimestamp(payload);
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractEvent.Builder<T> {
        private String category;
        private String action;
        private String label;
        private String property;
        private Double value;

        public T category(String category) {
            this.category = category;
            return (T)((Builder)this.self());
        }

        public T action(String action) {
            this.action = action;
            return (T)((Builder)this.self());
        }

        public T label(String label) {
            this.label = label;
            return (T)((Builder)this.self());
        }

        public T property(String property) {
            this.property = property;
            return (T)((Builder)this.self());
        }

        public T value(Double value) {
            this.value = value;
            return (T)((Builder)this.self());
        }

        public Structured build() {
            return new Structured(this);
        }
    }
}

