/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.events;

import com.snowplowanalytics.snowplow.tracker.events.AbstractEvent;
import com.snowplowanalytics.snowplow.tracker.payload.SelfDescribingJson;
import java.util.LinkedHashMap;
import java.util.Objects;

public class Timing
extends AbstractEvent {
    private final String category;
    private final String variable;
    private final Integer timing;
    private final String label;

    public static Builder<?> builder() {
        return new Builder2();
    }

    protected Timing(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).category);
        Objects.requireNonNull(((Builder)builder).timing);
        Objects.requireNonNull(((Builder)builder).variable);
        if (((Builder)builder).category.isEmpty()) {
            throw new IllegalArgumentException("category cannot be empty");
        }
        if (((Builder)builder).variable.isEmpty()) {
            throw new IllegalArgumentException("variable cannot be empty");
        }
        this.category = ((Builder)builder).category;
        this.variable = ((Builder)builder).variable;
        this.label = ((Builder)builder).label;
        this.timing = ((Builder)builder).timing;
    }

    @Override
    public SelfDescribingJson getPayload() {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("category", this.category);
        payload.put("label", this.label);
        payload.put("timing", this.timing);
        payload.put("variable", this.variable);
        return new SelfDescribingJson("iglu:com.snowplowanalytics.snowplow/timing/jsonschema/1-0-0", payload);
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractEvent.Builder<T> {
        private String category;
        private String variable;
        private Integer timing;
        private String label;

        public T category(String category) {
            this.category = category;
            return (T)((Builder)this.self());
        }

        public T variable(String variable) {
            this.variable = variable;
            return (T)((Builder)this.self());
        }

        public T timing(Integer timing) {
            this.timing = timing;
            return (T)((Builder)this.self());
        }

        public T label(String label) {
            this.label = label;
            return (T)((Builder)this.self());
        }

        public Timing build() {
            return new Timing(this);
        }
    }
}

