/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.http;

import com.snowplowanalytics.snowplow.tracker.Utils;
import com.snowplowanalytics.snowplow.tracker.http.HttpClientAdapter;
import com.snowplowanalytics.snowplow.tracker.payload.SelfDescribingJson;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;

public abstract class AbstractHttpClientAdapter
implements HttpClientAdapter {
    protected final String url;

    public AbstractHttpClientAdapter(String url) {
        this.url = url.replaceFirst("/*$", "");
    }

    @Deprecated
    public static Builder<?> builder() {
        return new Builder2();
    }

    @Deprecated
    protected AbstractHttpClientAdapter(Builder<?> builder) {
        if (!Utils.isValidUrl(((Builder)builder).url)) {
            throw new IllegalArgumentException();
        }
        this.url = ((Builder)builder).url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public int post(SelfDescribingJson payload) {
        String url = this.url + "/" + "com.snowplowanalytics.snowplow" + "/" + "tp2";
        String body = payload.toString();
        return this.doPost(url, body);
    }

    @Override
    public int get(TrackerPayload payload) {
        String url = this.url + "/i?" + Utils.mapToQueryString(payload.getMap());
        return this.doGet(url);
    }

    @Override
    public abstract Object getHttpClient();

    protected abstract int doPost(String var1, String var2);

    protected abstract int doGet(String var1);

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    @Deprecated
    public static abstract class Builder<T extends Builder<T>> {
        private String url;

        protected abstract T self();

        public T url(String url) {
            this.url = url.replaceFirst("/*$", "");
            return this.self();
        }
    }
}

