/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.http;

import com.snowplowanalytics.snowplow.tracker.http.AbstractHttpClientAdapter;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientAdapter
extends AbstractHttpClientAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheHttpClientAdapter.class);
    private CloseableHttpClient httpClient;

    public ApacheHttpClientAdapter(String url, CloseableHttpClient httpClient) {
        super(url);
        Objects.requireNonNull(httpClient);
        this.httpClient = httpClient;
    }

    @Deprecated
    public static Builder<?> builder() {
        return new Builder2();
    }

    @Deprecated
    protected ApacheHttpClientAdapter(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).httpClient);
        this.httpClient = ((Builder)builder).httpClient;
    }

    @Override
    public Object getHttpClient() {
        return this.httpClient;
    }

    @Override
    public int doGet(String url) {
        try {
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
            httpGet.releaseConnection();
            return httpResponse.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            LOGGER.error("ApacheHttpClient GET Request failed: {}", (Object)e.getMessage());
            return -1;
        }
    }

    @Override
    public int doPost(String url, String payload) {
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
            StringEntity params = new StringEntity(payload, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)params);
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            httpPost.releaseConnection();
            return httpResponse.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            LOGGER.error("ApacheHttpClient POST Request failed: {}", (Object)e.getMessage());
            return -1;
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    @Deprecated
    public static abstract class Builder<T extends Builder<T>>
    extends AbstractHttpClientAdapter.Builder<T> {
        private CloseableHttpClient httpClient;

        public T httpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return (T)((Builder)this.self());
        }

        public ApacheHttpClientAdapter build() {
            return new ApacheHttpClientAdapter(this);
        }
    }
}

