/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import okhttp3.Cookie;

public class CollectorCookie {
    private final Cookie cookie;

    static List<CollectorCookie> decorateAll(Collection<Cookie> cookies) {
        ArrayList<CollectorCookie> collectorCookies = new ArrayList<CollectorCookie>(cookies.size());
        for (Cookie cookie : cookies) {
            collectorCookies.add(new CollectorCookie(cookie));
        }
        return collectorCookies;
    }

    CollectorCookie(Cookie cookie) {
        this.cookie = cookie;
    }

    public boolean isExpired() {
        return this.cookie.expiresAt() < System.currentTimeMillis();
    }

    Cookie getCookie() {
        return this.cookie;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CollectorCookie)) {
            return false;
        }
        CollectorCookie that = (CollectorCookie)other;
        return that.cookie.name().equals(this.cookie.name()) && that.cookie.domain().equals(this.cookie.domain()) && that.cookie.path().equals(this.cookie.path());
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.cookie.name().hashCode();
        hash = 31 * hash + this.cookie.domain().hashCode();
        hash = 31 * hash + this.cookie.path().hashCode();
        return hash;
    }
}

