/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.http;

import com.snowplowanalytics.snowplow.tracker.http.CollectorCookie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class CollectorCookieJar
implements CookieJar {
    private static final Set<CollectorCookie> cookies = Collections.newSetFromMap(new ConcurrentHashMap());

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<CollectorCookie> cookiesToRemove = new ArrayList<CollectorCookie>();
        ArrayList<Cookie> validCookies = new ArrayList<Cookie>();
        for (CollectorCookie currentCookie : cookies) {
            if (currentCookie.isExpired()) {
                cookiesToRemove.add(currentCookie);
                continue;
            }
            if (!currentCookie.getCookie().matches(url)) continue;
            validCookies.add(currentCookie.getCookie());
        }
        if (!cookiesToRemove.isEmpty()) {
            this.removeAll(cookiesToRemove);
        }
        return validCookies;
    }

    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> cookies) {
        this.saveAll(cookies);
    }

    public void clear() {
        cookies.clear();
    }

    private void saveAll(Collection<Cookie> newCookies) {
        for (CollectorCookie cookie : CollectorCookie.decorateAll(newCookies)) {
            cookies.remove(cookie);
            cookies.add(cookie);
        }
    }

    private void removeAll(Collection<CollectorCookie> cookiesToRemove) {
        for (CollectorCookie cookie : cookiesToRemove) {
            cookies.remove(cookie);
        }
    }
}

