/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.http;

import com.snowplowanalytics.snowplow.tracker.http.AbstractHttpClientAdapter;
import java.io.IOException;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientAdapter
extends AbstractHttpClientAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkHttpClientAdapter.class);
    private final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private OkHttpClient httpClient;

    public OkHttpClientAdapter(String url, OkHttpClient httpClient) {
        super(url);
        Objects.requireNonNull(httpClient);
        this.httpClient = httpClient;
    }

    @Deprecated
    public static Builder<?> builder() {
        return new Builder2();
    }

    @Deprecated
    protected OkHttpClientAdapter(Builder<?> builder) {
        super(builder);
        Objects.requireNonNull(((Builder)builder).httpClient);
        this.httpClient = ((Builder)builder).httpClient;
    }

    @Override
    public Object getHttpClient() {
        return this.httpClient;
    }

    @Override
    public int doGet(String url) {
        int returnValue = -1;
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                LOGGER.error("OkHttpClient GET Request failed: {}", (Object)response);
            }
            returnValue = response.code();
        }
        catch (IOException e) {
            LOGGER.error("OkHttpClient GET Request failed: {}", (Object)e.getMessage());
        }
        return returnValue;
    }

    @Override
    public int doPost(String url, String payload) {
        int returnValue = -1;
        RequestBody body = RequestBody.create((String)payload, (MediaType)this.JSON);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json; charset=utf-8").post(body).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                LOGGER.error("OkHttpClient POST Request failed: {}", (Object)response);
            }
            returnValue = response.code();
        }
        catch (IOException e) {
            LOGGER.error("OkHttpClient POST Request failed: {}", (Object)e.getMessage());
        }
        return returnValue;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    @Deprecated
    public static abstract class Builder<T extends Builder<T>>
    extends AbstractHttpClientAdapter.Builder<T> {
        private OkHttpClient httpClient;

        public T httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return (T)((Builder)this.self());
        }

        public OkHttpClientAdapter build() {
            return new OkHttpClientAdapter(this);
        }
    }
}

