/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.payload;

import com.snowplowanalytics.snowplow.tracker.Utils;
import com.snowplowanalytics.snowplow.tracker.payload.Payload;
import com.snowplowanalytics.snowplow.tracker.payload.TrackerPayload;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfDescribingJson
implements Payload {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfDescribingJson.class);
    private final LinkedHashMap<String, Object> payload = new LinkedHashMap();

    public SelfDescribingJson(String schema) {
        this(schema, new LinkedHashMap());
    }

    public SelfDescribingJson(String schema, TrackerPayload data) {
        this.setSchema(schema);
        this.setData(data);
    }

    public SelfDescribingJson(String schema, SelfDescribingJson data) {
        this.setSchema(schema);
        this.setData(data);
    }

    public SelfDescribingJson(String schema, Object data) {
        this.setSchema(schema);
        this.setData(data);
    }

    public SelfDescribingJson setSchema(String schema) {
        Objects.requireNonNull(schema, "schema cannot be null");
        if (schema.isEmpty()) {
            throw new IllegalArgumentException("schema cannot be empty");
        }
        this.payload.put("schema", schema);
        return this;
    }

    public SelfDescribingJson setData(TrackerPayload data) {
        if (data == null) {
            return this;
        }
        this.payload.put("data", data.getMap());
        return this;
    }

    public SelfDescribingJson setData(Object data) {
        if (data == null) {
            return this;
        }
        this.payload.put("data", data);
        return this;
    }

    public SelfDescribingJson setData(SelfDescribingJson data) {
        if (this.payload == null) {
            return this;
        }
        this.payload.put("data", data.getMap());
        return this;
    }

    @Override
    @Deprecated
    public void add(String key, String value) {
        LOGGER.info("Payload: add(String, String) method called - Doing nothing.");
    }

    @Override
    @Deprecated
    public void addMap(Map<String, String> map) {
        LOGGER.info("Payload: addMap(Map<String, Object>) method called - Doing nothing.");
    }

    @Override
    @Deprecated
    public void addMap(Map<String, ?> map, boolean base64Encoded, String typeEncoded, String typeNotEncoded) {
        LOGGER.info("Payload: addMap(Map, boolean, String, String) method called - Doing nothing.");
    }

    public Map<String, Object> getMap() {
        return this.payload;
    }

    @Override
    public long getByteSize() {
        return Utils.getUTF8Length(this.toString());
    }

    @Override
    public String toString() {
        return Utils.mapToJSONString(this.payload);
    }
}

