/*
 * Decompiled with CFR 0.152.
 */
package com.snowplowanalytics.snowplow.tracker.payload;

import com.snowplowanalytics.snowplow.tracker.Utils;
import com.snowplowanalytics.snowplow.tracker.payload.Payload;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerPayload
implements Payload {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerPayload.class);
    protected final Map<String, String> payload = new LinkedHashMap<String, String>();
    private final String eventId = Utils.getEventId();
    private final Long deviceCreatedTimestamp = System.currentTimeMillis();

    public TrackerPayload() {
        this.add("eid", this.eventId);
        this.add("dtm", Long.toString(this.deviceCreatedTimestamp));
    }

    public String getEventId() {
        return this.eventId;
    }

    public Long getDeviceCreatedTimestamp() {
        return this.deviceCreatedTimestamp;
    }

    @Override
    public void add(String key, String value) {
        if (key == null || key.isEmpty()) {
            LOGGER.error("Null or empty key detected");
            return;
        }
        if (value == null || value.isEmpty()) {
            LOGGER.debug("Null or empty value detected: {}->{}", (Object)key, (Object)value);
            return;
        }
        LOGGER.debug("Adding new kv pair: {}->{}", (Object)key, (Object)value);
        this.payload.put(key, value);
    }

    @Override
    public void addMap(Map<String, String> map) {
        if (map == null) {
            LOGGER.debug("Map passed in is null, returning without adding map.");
            return;
        }
        LOGGER.debug("Adding new map: {}", map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addMap(Map<String, ?> map, boolean base64Encoded, String typeEncoded, String typeNotEncoded) {
        if (map == null) {
            LOGGER.debug("Map passed in is null, returning nothing.");
            return;
        }
        String mapString = Utils.mapToJSONString(map);
        LOGGER.debug("Adding new map: {}", map);
        if (base64Encoded) {
            this.add(typeEncoded, Utils.base64Encode(mapString, StandardCharsets.UTF_8));
        } else {
            this.add(typeNotEncoded, mapString);
        }
    }

    public Map<String, String> getMap() {
        return this.payload;
    }

    @Override
    public long getByteSize() {
        return Utils.getUTF8Length(this.toString());
    }

    @Override
    public String toString() {
        return Utils.mapToJSONString(this.payload);
    }
}

