/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.customhttp;

import com.sobot.network.customhttp.bean.CommCallback;
import com.sobot.network.customhttp.bean.HttpBody;
import com.sobot.network.customhttp.bean.ICommCallback;
import com.sobot.network.customhttp.module.DownLoadHttpRequester;
import com.sobot.network.customhttp.module.GetHttpRequester;
import com.sobot.network.customhttp.module.PostHttpRequester;
import com.sobot.network.customhttp.module.ProvideHttpRequester;
import com.sobot.network.customhttp.module.UpLoadHttpRequester;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;

public class SobotCustomHttpUtils {
    private static final String TAG = "MyHttpUtils";
    private HttpBody mHttpBody = new HttpBody();
    private ICommCallback callback;

    public static SobotCustomHttpUtils build() {
        return new SobotCustomHttpUtils();
    }

    public SobotCustomHttpUtils url(String url) {
        this.mHttpBody.setUrl(url);
        return this;
    }

    public SobotCustomHttpUtils uploadUrl(String uploadUrl) {
        this.mHttpBody.setUploadUrl(uploadUrl);
        return this;
    }

    public SobotCustomHttpUtils setReadTimeOut(int readTimeOut) {
        this.mHttpBody.setReadTimeOut(readTimeOut);
        return this;
    }

    public SobotCustomHttpUtils setConnTimeOut(int connTimeOut) {
        this.mHttpBody.setConnTimeOut(connTimeOut);
        return this;
    }

    public SobotCustomHttpUtils setHttpBody(HttpBody mHttpBody) {
        this.mHttpBody = mHttpBody;
        return this;
    }

    public HttpBody getHttpBody() {
        return this.mHttpBody;
    }

    public SobotCustomHttpUtils addParam(String key, Object value) {
        this.mHttpBody.addParam(key, value);
        return this;
    }

    public SobotCustomHttpUtils setContentType(String contentType) {
        this.mHttpBody.setContentType(contentType);
        return this;
    }

    public SobotCustomHttpUtils addParams(Map<String, Object> params) {
        this.mHttpBody.setParams(params);
        return this;
    }

    public SobotCustomHttpUtils addHeaders(Map<String, String> headers) {
        this.mHttpBody.setHeaders(headers);
        return this;
    }

    public SobotCustomHttpUtils setFileSaveDir(String dir) {
        this.mHttpBody.setFileSaveDir(dir);
        return this;
    }

    public SobotCustomHttpUtils addFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            this.mHttpBody.addFile(filePath);
        } else {
            this.callback.onFailed(new FileNotFoundException("NOFile"));
        }
        return this;
    }

    public SobotCustomHttpUtils addFile(File file) {
        if (file.exists()) {
            this.mHttpBody.addFile(file);
        } else {
            this.callback.onFailed(new FileNotFoundException("NOFile"));
        }
        return this;
    }

    public SobotCustomHttpUtils addFiles(List<File> fileList) {
        for (File file : fileList) {
            if (file.exists()) {
                this.mHttpBody.addFile(file);
                continue;
            }
            this.callback.onFailed(new FileNotFoundException("NOFile"));
        }
        return this;
    }

    public SobotCustomHttpUtils addFilesByPath(List<String> filePaths) {
        for (String filePath : filePaths) {
            if (new File(filePath).exists()) {
                this.mHttpBody.addFile(filePath);
                continue;
            }
            this.callback.onFailed(new FileNotFoundException("NOFile"));
        }
        return this;
    }

    public SobotCustomHttpUtils onExecute(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new GetHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }

    public SobotCustomHttpUtils onExecuteByPost(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new PostHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }

    public SobotCustomHttpUtils onExecuteDwonload(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new DownLoadHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }

    public SobotCustomHttpUtils onExecuteUpLoad(CommCallback callback) {
        this.callback = callback;
        ProvideHttpRequester requester = new ProvideHttpRequester(new UpLoadHttpRequester(this.mHttpBody, callback));
        requester.startRequest();
        return this;
    }
}

