/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.customhttp.module;

import android.os.Message;
import com.sobot.network.customhttp.bean.HttpBody;
import com.sobot.network.customhttp.bean.ICommCallback;
import com.sobot.network.customhttp.module.HttpRequester;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class UpLoadHttpRequester
extends HttpRequester {
    public UpLoadHttpRequester(HttpBody mHttpBody, ICommCallback callback) {
        this.mHttpBody = mHttpBody;
        this.callback = callback;
    }

    @Override
    public void request() {
        new Thread(){

            @Override
            public void run() {
                String BOUNDARY = UUID.randomUUID().toString();
                String PREFIX = "--";
                String LINE_END = "\r\n";
                String CONTENT_TYPE = "multipart/form-data";
                try {
                    URL url = new URL(UpLoadHttpRequester.this.mHttpBody.getUploadUrl());
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setReadTimeout(UpLoadHttpRequester.this.mHttpBody.getReadTimeOut());
                    conn.setConnectTimeout(UpLoadHttpRequester.this.mHttpBody.getConnTimeOut());
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Charset", "utf-8");
                    conn.setRequestProperty("connection", "keep-alive");
                    conn.setRequestProperty("Content-Type", CONTENT_TYPE + ";boundary=" + BOUNDARY);
                    if (UpLoadHttpRequester.this.mHttpBody.getHeaders() != null) {
                        Set<Map.Entry<String, String>> entries = UpLoadHttpRequester.this.mHttpBody.getHeaders().entrySet();
                        for (Map.Entry<String, String> entry : entries) {
                            conn.setRequestProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    OutputStream outputSteam = conn.getOutputStream();
                    DataOutputStream dos = new DataOutputStream(outputSteam);
                    if (UpLoadHttpRequester.this.mHttpBody.getFiles() != null && UpLoadHttpRequester.this.mHttpBody.getFiles().size() > 0) {
                        for (File file : UpLoadHttpRequester.this.mHttpBody.getFiles()) {
                            StringBuffer sb = new StringBuffer();
                            if (UpLoadHttpRequester.this.mHttpBody.getParams() != null || UpLoadHttpRequester.this.mHttpBody.getParams().size() > 0) {
                                for (Map.Entry<String, Object> entry : UpLoadHttpRequester.this.mHttpBody.getParams().entrySet()) {
                                    sb.append(PREFIX).append(BOUNDARY).append(LINE_END);
                                    sb.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINE_END);
                                    sb.append("Content-Type: text/plain; charset=utf-8" + LINE_END);
                                    sb.append("Content-Transfer-Encoding: 8bit" + LINE_END);
                                    sb.append(LINE_END);
                                    sb.append(entry.getValue());
                                    sb.append(LINE_END);
                                }
                            }
                            sb.append(PREFIX);
                            sb.append(BOUNDARY);
                            sb.append(LINE_END);
                            sb.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"" + LINE_END);
                            sb.append("Content-Type: application/octet-stream; charset=utf-8" + LINE_END);
                            sb.append(LINE_END);
                            dos.write(sb.toString().getBytes());
                            FileInputStream fis = new FileInputStream(file);
                            byte[] bytes = new byte[0x100000];
                            int len = 0;
                            while ((len = fis.read(bytes)) != -1) {
                                dos.write(bytes, 0, len);
                            }
                            fis.close();
                            dos.write(LINE_END.getBytes());
                        }
                        byte[] byArray = (PREFIX + BOUNDARY + PREFIX + LINE_END).getBytes();
                        dos.write(byArray);
                        dos.flush();
                        dos.close();
                        StringBuilder json = new StringBuilder();
                        if (conn.getResponseCode() == 200) {
                            int length = 0;
                            byte[] buf = new byte[0x100000];
                            InputStream cis = conn.getInputStream();
                            while ((length = cis.read(buf)) != -1) {
                                json.append(new String(buf, 0, length));
                            }
                            cis.close();
                            Message msg = UpLoadHttpRequester.this.mHandler.obtainMessage();
                            msg.what = 1007;
                            msg.obj = json.toString();
                            UpLoadHttpRequester.this.mHandler.sendMessage(msg);
                        } else {
                            UpLoadHttpRequester.this.mHandler.sendEmptyMessage(1002);
                        }
                    } else {
                        UpLoadHttpRequester.this.mHandler.sendEmptyMessage(1008);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    UpLoadHttpRequester.this.mHandler.sendEmptyMessage(1003);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    UpLoadHttpRequester.this.mHandler.sendEmptyMessage(1004);
                }
            }
        }.start();
    }
}

