/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http;

import android.os.Build;
import android.text.TextUtils;
import com.sobot.network.customhttp.SobotCustomHttpUtils;
import com.sobot.network.customhttp.bean.CommCallback;
import com.sobot.network.http.SobotOkHttpUtils;
import com.sobot.network.http.builder.GetBuilder;
import com.sobot.network.http.builder.OtherRequestBuilder;
import com.sobot.network.http.builder.PostFormBuilder;
import com.sobot.network.http.builder.PostStringBuilder;
import com.sobot.network.http.callback.StringCallback;
import com.sobot.network.http.download.SobotDownload;
import com.sobot.network.http.download.SobotDownloadTask;
import com.sobot.network.http.log.SobotNetLogUtils;
import com.sobot.network.http.request.RequestCall;
import com.sobot.network.http.upload.SobotUpload;
import com.sobot.network.http.upload.SobotUploadTask;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;

public class HttpBaseUtils {
    private static HttpBaseUtils client = null;

    private HttpBaseUtils() {
    }

    public static HttpBaseUtils getInstance() {
        if (client == null) {
            client = new HttpBaseUtils();
        }
        return client;
    }

    public void doPost(Object cancelTag, String url_str, Map<String, Object> paramMap, Map<String, String> headerMap, StringCallBack callback) {
        this.doPost(cancelTag, url_str, 8000L, paramMap, headerMap, callback);
    }

    public void doPost(Object cancelTag, final String url_str, long timeOut, Map<String, Object> paramMap, Map<String, String> headerMap, final StringCallBack callback) {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ((PostFormBuilder)((PostFormBuilder)SobotOkHttpUtils.post().tag(cancelTag).url(url_str).headers((Map)headerMap)).params((Map)paramMap)).build().readTimeOut(timeOut).writeTimeOut(timeOut).connTimeOut(timeOut).execute(new StringCallback(){

                @Override
                public void onResponse(String response) {
                    SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                    callback.onResponse(response);
                }

                @Override
                public void onError(Call call, Exception e) {
                    SobotNetLogUtils.i(call.toString());
                    e.printStackTrace();
                    callback.onError(e, call.toString(), -1);
                }
            });
        } else {
            SobotCustomHttpUtils.build().url(url_str).addParams(paramMap).addHeaders(headerMap).onExecuteByPost(new com.sobot.network.customhttp.bean.StringCallBack(){

                @Override
                public void onSucceed(String response) {
                    SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                    callback.onResponse(response);
                }

                @Override
                public void onFailed(Exception e) {
                    SobotNetLogUtils.i(e.toString());
                    callback.onError(e, e.getMessage(), -1);
                }
            });
        }
    }

    public void doPostByJsonString(Object cancelTag, final String url_str, Map<String, Object> paramMap, Map<String, String> headerMap, final StringCallBack callback) {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ((PostStringBuilder)SobotOkHttpUtils.postString().tag(cancelTag).url(url_str).headers((Map)headerMap)).mediaType(MediaType.get((String)"application/json")).content(HttpBaseUtils.map2Json(paramMap)).build().readTimeOut(8000L).writeTimeOut(8000L).connTimeOut(8000L).execute(new StringCallback(){

                @Override
                public void onResponse(String response) {
                    SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                    callback.onResponse(response);
                }

                @Override
                public void onError(Call call, Exception e) {
                    SobotNetLogUtils.i(call.toString());
                    e.printStackTrace();
                    callback.onError(e, call.toString(), -1);
                }
            });
        } else {
            SobotCustomHttpUtils.build().url(url_str).setContentType("application/json").addParams(paramMap).addHeaders(headerMap).onExecuteByPost(new com.sobot.network.customhttp.bean.StringCallBack(){

                @Override
                public void onSucceed(String response) {
                    SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                    callback.onResponse(response);
                }

                @Override
                public void onFailed(Exception e) {
                    SobotNetLogUtils.i(e.toString());
                    callback.onError(e, e.getMessage(), -1);
                }
            });
        }
    }

    public void doGet(Object cancelTag, String url_str, Map<String, Object> paramMap, Map<String, String> headerMap, StringCallBack callback) {
        this.doGet(cancelTag, url_str, 8000L, paramMap, headerMap, callback);
    }

    public void doGet(Object cancelTag, final String url_str, long timeOut, Map<String, Object> paramMap, Map<String, String> headerMap, final StringCallBack callback) {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ((GetBuilder)((GetBuilder)SobotOkHttpUtils.get().tag(cancelTag).url(url_str).params((Map)paramMap)).headers((Map)headerMap)).build().readTimeOut(timeOut).writeTimeOut(timeOut).connTimeOut(timeOut).execute(new StringCallback(){

                @Override
                public void onResponse(String response) {
                    SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                    callback.onResponse(response);
                }

                @Override
                public void onError(Call call, Exception e) {
                    SobotNetLogUtils.i(call.toString());
                    e.printStackTrace();
                    callback.onError(e, call.toString(), -1);
                }
            });
        } else {
            SobotCustomHttpUtils.build().url(url_str).addParams(paramMap).addHeaders(headerMap).onExecute(new com.sobot.network.customhttp.bean.StringCallBack(){

                @Override
                public void onSucceed(String response) {
                    SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                    callback.onResponse(response);
                }

                @Override
                public void onFailed(Exception e) {
                    SobotNetLogUtils.i(e.toString());
                    callback.onError(e, e.getMessage(), -1);
                }
            });
        }
    }

    private static FormBody addParamToBuilder(Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (params != null && params.keySet().size() > 0) {
            try {
                for (String key : params.keySet()) {
                    builder.add(key, params.get(key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public void doPut(Object cancelTag, final String url_str, Map<String, String> paramMap, Map<String, String> headerMap, final StringCallBack callback) {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        FormBody formBody = HttpBaseUtils.addParamToBuilder(paramMap);
        ((OtherRequestBuilder)SobotOkHttpUtils.put().requestBody((RequestBody)formBody).tag(cancelTag).url(url_str).headers((Map)headerMap)).build().readTimeOut(8000L).writeTimeOut(8000L).connTimeOut(8000L).execute(new StringCallback(){

            @Override
            public void onResponse(String response) {
                SobotNetLogUtils.i(url_str + "----\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c: --> " + response);
                callback.onResponse(response);
            }

            @Override
            public void onError(Call call, Exception e) {
                SobotNetLogUtils.i(call.toString());
                e.printStackTrace();
                callback.onError(e, call.toString(), -1);
            }
        });
    }

    public void download(String url_str, final File file, final FileCallBack callback) {
        SobotNetLogUtils.i("\u4e0b\u8f7d\u5730\u5740\uff1a" + url_str);
        if (Build.VERSION.SDK_INT >= 21) {
            SobotOkHttpUtils.get().url(url_str).build().connTimeOut(30000L).readTimeOut(30000L).writeTimeOut(30000L).execute(new com.sobot.network.http.callback.FileCallBack(file.getAbsolutePath()){

                @Override
                public void onError(Call call, Exception e) {
                    callback.onError(e, call.toString(), -1);
                }

                @Override
                public void onResponse(File file) {
                    callback.onResponse(file);
                }

                @Override
                public void inProgress(float progress, long total) {
                    callback.inProgress((int)(progress * 100.0f));
                }
            });
        } else {
            SobotCustomHttpUtils.build().url(url_str).setFileSaveDir(file.getAbsolutePath()).setConnTimeOut(6000).setReadTimeOut(300000).onExecuteDwonload(new CommCallback(){

                @Override
                public void onSucceed(Object o) {
                }

                @Override
                public void onFailed(Exception e) {
                    callback.onError(e, e.getMessage(), -1);
                }

                @Override
                public void onDownLoadFinished() {
                    callback.onResponse(file);
                }

                @Override
                public void onDownloading(long total, long current) {
                    callback.inProgress((int)((double)current / (double)total * 100.0));
                }
            });
        }
    }

    public void uploadFile(Object cancelTag, String url_str, Map<String, Object> paramMap, Map<String, String> headerMap, String path, final StringCallBack callback) {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        SobotNetLogUtils.i("\u4e0a\u4f20\u6587\u4ef6\u5730\u5740: --> " + path);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            File file;
            PostFormBuilder post = SobotOkHttpUtils.post();
            if (!TextUtils.isEmpty((CharSequence)path) && (file = new File(path)).exists() && file.isFile()) {
                post.addFile("file", file.getName(), file);
            }
            ((PostFormBuilder)((PostFormBuilder)post.url(url_str).params((Map)paramMap)).headers((Map)headerMap)).tag(cancelTag).build().connTimeOut(30000L).readTimeOut(30000L).writeTimeOut(30000L).execute(new StringCallback(){

                @Override
                public void onResponse(String response) {
                    SobotNetLogUtils.i("\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c:" + response);
                    callback.onResponse(response);
                }

                @Override
                public void onError(Call call, Exception e) {
                    callback.onError(e, call.toString(), -1);
                }

                @Override
                public void inProgress(float progress) {
                    super.inProgress(progress);
                    callback.inProgress((int)(progress * 100.0f));
                }
            });
        } else {
            File file = null;
            if (!TextUtils.isEmpty((CharSequence)path)) {
                file = new File(path);
            }
            if (file == null) {
                SobotNetLogUtils.e("\u4e0a\u4f20\u6587\u4ef6 " + path + " \u4e0d\u5b58\u5728\uff0c\u4e0d\u6267\u884c\u4e0a\u4f20\u8bf7\u6c42");
            }
            SobotCustomHttpUtils.build().uploadUrl(url_str).addFile(file).addParams(paramMap).addHeaders(headerMap).setConnTimeOut(6000).setReadTimeOut(300000).onExecuteUpLoad(new CommCallback(){

                @Override
                public void onSucceed(Object o) {
                }

                @Override
                public void onFailed(Exception e) {
                    callback.onError(e, e.getMessage(), -1);
                }

                @Override
                public void onUploadFinished(String result) {
                    callback.onResponse(result);
                    SobotNetLogUtils.i("\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c:" + result);
                }

                @Override
                public void onDownloading(long total, long current) {
                }
            });
        }
    }

    public SobotUploadTask addUploadFileTask(String msgTag, String url_str, Map<String, Object> paramMap, Map<String, String> headerMap, String path, String imageFile) {
        SobotNetLogUtils.i("\u4e0a\u4f20\u6587\u4ef6 \u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u4e0a\u4f20\u6587\u4ef6 \u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        PostFormBuilder post = SobotOkHttpUtils.post();
        if (!TextUtils.isEmpty((CharSequence)path)) {
            File file = new File(path);
            post.addFile("file", file.getName(), file);
        }
        if (!TextUtils.isEmpty((CharSequence)imageFile)) {
            File file2 = new File(imageFile);
            post.addFile("imageFile", file2.getName(), file2);
        }
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        RequestCall requestCall = ((PostFormBuilder)((PostFormBuilder)post.url(url_str).params((Map)paramMap)).headers((Map)headerMap)).build().connTimeOut(30000L).readTimeOut(30000L).writeTimeOut(30000L);
        Random random = new Random();
        return SobotUpload.request(msgTag, requestCall).priority(random.nextInt(100)).tmpTag(msgTag).filePath(path).start();
    }

    public SobotDownloadTask addDownloadFileTask(String msgTag, String url_str, String fileName, Map<String, Object> paramMap, Map<String, String> headerMap) {
        if (TextUtils.isEmpty((CharSequence)msgTag) || TextUtils.isEmpty((CharSequence)url_str)) {
            return null;
        }
        Random random = new Random();
        return SobotDownload.request(msgTag, this.obtainGetRequest(url_str, paramMap, headerMap)).priority(random.nextInt(100)).fileName(fileName).save();
    }

    public RequestCall obtainGetRequest(String url_str, Map<String, Object> paramMap, Map<String, String> headerMap) {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        return ((GetBuilder)((GetBuilder)SobotOkHttpUtils.get().url(url_str).headers((Map)headerMap)).params((Map)paramMap)).build().connTimeOut(30000L).readTimeOut(30000L).writeTimeOut(30000L);
    }

    public Response doPostSync(Object cancelTag, String url_str, Map<String, Object> paramMap, Map<String, String> headerMap) throws IOException {
        SobotNetLogUtils.i("\u8bf7\u6c42URL: --> " + url_str);
        SobotNetLogUtils.i("\u8bf7\u6c42\u53c2\u6570: --> " + paramMap);
        SobotNetLogUtils.i("\u8bf7\u6c42\u5934\u53c2\u6570: --> " + headerMap);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        return ((PostFormBuilder)((PostFormBuilder)SobotOkHttpUtils.post().tag(cancelTag).url(url_str).headers((Map)headerMap)).params((Map)paramMap)).build().readTimeOut(8000L).writeTimeOut(8000L).connTimeOut(8000L).execute();
    }

    public static String map2Json(Map<String, Object> map) {
        if (map != null && map.size() > 0) {
            JSONObject a = new JSONObject(map);
            return a.toString();
        }
        return "";
    }

    public static interface FileCallBack {
        public void onResponse(File var1);

        public void onError(Exception var1, String var2, int var3);

        public void inProgress(int var1);
    }

    public static interface StringCallBack {
        public void onResponse(String var1);

        public void onError(Exception var1, String var2, int var3);

        public void inProgress(int var1);
    }
}

