/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import com.sobot.network.http.SobotInternetPermissionExceptionInterceptor;
import com.sobot.network.http.builder.GetBuilder;
import com.sobot.network.http.builder.HeadBuilder;
import com.sobot.network.http.builder.OtherRequestBuilder;
import com.sobot.network.http.builder.PostFileBuilder;
import com.sobot.network.http.builder.PostFormBuilder;
import com.sobot.network.http.builder.PostMultipartFormBuilder;
import com.sobot.network.http.builder.PostStringBuilder;
import com.sobot.network.http.callback.Callback;
import com.sobot.network.http.callback.FileCallBack;
import com.sobot.network.http.log.LoggerInterceptor;
import com.sobot.network.http.request.RequestCall;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.internal.Util;

public class SobotOkHttpUtils {
    public static final long DEFAULT_MILLISECONDS = 10000L;
    private static SobotOkHttpUtils mInstance;
    private OkHttpClient mOkHttpClient;
    private Handler mDelivery;

    public SobotOkHttpUtils(OkHttpClient okHttpClient) {
        if (okHttpClient == null) {
            OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
            okHttpClientBuilder.retryOnConnectionFailure(false);
            okHttpClientBuilder.addInterceptor((Interceptor)new SobotInternetPermissionExceptionInterceptor());
            this.mDelivery = new Handler(Looper.getMainLooper());
            try {
                X509TrustManager manager = SobotOkHttpUtils.platformTrustManager();
                okHttpClientBuilder.sslSocketFactory(SobotOkHttpUtils.createSSLSocketFactory(manager), manager);
                this.mOkHttpClient = okHttpClientBuilder.build();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.mOkHttpClient = okHttpClient;
        }
    }

    public SobotOkHttpUtils debug(String tag) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().addInterceptor((Interceptor)new LoggerInterceptor(tag, false)).build();
        return this;
    }

    public SobotOkHttpUtils debug(String tag, boolean showResponse) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().addInterceptor((Interceptor)new LoggerInterceptor(tag, showResponse)).build();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SobotOkHttpUtils getInstance(OkHttpClient okHttpClient) {
        if (mInstance != null) return mInstance;
        Class<SobotOkHttpUtils> clazz = SobotOkHttpUtils.class;
        synchronized (SobotOkHttpUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new SobotOkHttpUtils(okHttpClient);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SobotOkHttpUtils getInstance() {
        if (mInstance != null) return mInstance;
        Class<SobotOkHttpUtils> clazz = SobotOkHttpUtils.class;
        synchronized (SobotOkHttpUtils.class) {
            if (mInstance != null) return mInstance;
            mInstance = new SobotOkHttpUtils(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void setOkHttpClient(OkHttpClient client) {
        this.mOkHttpClient = client;
    }

    public Handler getDelivery() {
        return this.mDelivery;
    }

    public OkHttpClient getOkHttpClient() {
        return this.mOkHttpClient;
    }

    public static GetBuilder get() {
        return new GetBuilder();
    }

    public static PostStringBuilder postString() {
        return new PostStringBuilder();
    }

    public static PostFileBuilder postFile() {
        return new PostFileBuilder();
    }

    public static PostFormBuilder post() {
        return new PostFormBuilder();
    }

    public static PostMultipartFormBuilder postMultipart() {
        return new PostMultipartFormBuilder();
    }

    public static OtherRequestBuilder put() {
        return new OtherRequestBuilder("PUT");
    }

    public static HeadBuilder head() {
        return new HeadBuilder();
    }

    public static OtherRequestBuilder delete() {
        return new OtherRequestBuilder("DELETE");
    }

    public static OtherRequestBuilder patch() {
        return new OtherRequestBuilder("PATCH");
    }

    public void execute(RequestCall requestCall, Callback callback) {
        if (callback == null) {
            callback = Callback.CALLBACK_DEFAULT;
        }
        final Callback finalCallback = callback;
        requestCall.getCall().enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                SobotOkHttpUtils.this.sendFailResultCallback(call, e, finalCallback);
            }

            public void onResponse(Call call, Response response) {
                if (!response.isSuccessful()) {
                    try {
                        SobotOkHttpUtils.this.sendFailResultCallback(call, new RuntimeException(response.body().string()), finalCallback);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    Object o = finalCallback.parseNetworkResponse(response);
                    SobotOkHttpUtils.this.sendSuccessResultCallback(o, finalCallback);
                }
                catch (Exception e) {
                    SobotOkHttpUtils.this.sendFailResultCallback(call, e, finalCallback);
                }
            }
        });
    }

    public void sendFailResultCallback(final Call call, final Exception e, final Callback callback) {
        if (callback == null || call.isCanceled()) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onError(call, e);
                callback.onAfter();
            }
        });
    }

    public void sendSuccessResultCallback(final Object object, final Callback callback) {
        if (callback == null) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                callback.onResponse(object);
                callback.onAfter();
            }
        });
    }

    public static void runOnUiThread(Runnable runnable) {
        SobotOkHttpUtils.getInstance().mDelivery.post(runnable);
    }

    public void cancelTag(Object tag) {
        for (Call call : this.mOkHttpClient.dispatcher().queuedCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
        for (Call call : this.mOkHttpClient.dispatcher().runningCalls()) {
            if (!tag.equals(call.request().tag())) continue;
            call.cancel();
        }
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().hostnameVerifier(hostNameVerifier).build();
    }

    public void setConnectTimeout(int timeout, TimeUnit units) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().connectTimeout((long)timeout, units).build();
    }

    public void setReadTimeout(int timeout, TimeUnit units) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().readTimeout((long)timeout, units).build();
    }

    public void setWriteTimeout(int timeout, TimeUnit units) {
        this.mOkHttpClient = this.getOkHttpClient().newBuilder().writeTimeout((long)timeout, units).build();
    }

    public static void download(String url, FileCallBack fileCallBack) {
        SobotOkHttpUtils.get().url(url).build().execute(fileCallBack);
    }

    @SuppressLint(value={"TrulyRandom"})
    private static SSLSocketFactory createSSLSocketFactory(X509TrustManager trustManager) {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            sSLSocketFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sSLSocketFactory;
    }

    public static X509TrustManager platformTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw Util.assertionError((String)"No System TLS", (Exception)e);
        }
    }

    public static class METHOD {
        public static final String HEAD = "HEAD";
        public static final String DELETE = "DELETE";
        public static final String PUT = "PUT";
        public static final String PATCH = "PATCH";
    }
}

