/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.cookie;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.sobot.network.http.cookie.SerializableHttpCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PersistentCookieStore
implements CookieStore {
    private static final String LOG_TAG = "PersistentCookieStore";
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final HashMap<String, ConcurrentHashMap<String, HttpCookie>> cookies;
    private final SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new HashMap();
        Map prefsMap = this.cookiePrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String[] cookieNames;
            if ((String)entry.getValue() == null || ((String)entry.getValue()).startsWith(COOKIE_NAME_PREFIX)) continue;
            for (String name : cookieNames = TextUtils.split((String)((String)entry.getValue()), (String)",")) {
                HttpCookie decodedCookie;
                String encodedCookie = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + name, null);
                if (encodedCookie == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null) continue;
                if (!this.cookies.containsKey(entry.getKey())) {
                    this.cookies.put((String)entry.getKey(), new ConcurrentHashMap());
                }
                this.cookies.get(entry.getKey()).put(name, decodedCookie);
            }
        }
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        String name = this.getCookieToken(uri, cookie);
        if (!cookie.hasExpired()) {
            if (!this.cookies.containsKey(uri.getHost())) {
                this.cookies.put(uri.getHost(), new ConcurrentHashMap());
            }
            this.cookies.get(uri.getHost()).put(name, cookie);
        } else if (this.cookies.containsKey(uri.toString())) {
            this.cookies.get(uri.getHost()).remove(name);
        }
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.putString(uri.getHost(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(uri.getHost()).keySet()));
        prefsWriter.putString(COOKIE_NAME_PREFIX + name, this.encodeCookie(new SerializableHttpCookie(cookie)));
        prefsWriter.commit();
    }

    protected String getCookieToken(URI uri, HttpCookie cookie) {
        return cookie.getName() + cookie.getDomain();
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        ArrayList<HttpCookie> ret = new ArrayList<HttpCookie>();
        if (this.cookies.containsKey(uri.getHost())) {
            ret.addAll(this.cookies.get(uri.getHost()).values());
        }
        return ret;
    }

    @Override
    public boolean removeAll() {
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.clear();
        prefsWriter.commit();
        this.cookies.clear();
        return true;
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        String name = this.getCookieToken(uri, cookie);
        if (this.cookies.containsKey(uri.getHost()) && this.cookies.get(uri.getHost()).containsKey(name)) {
            this.cookies.get(uri.getHost()).remove(name);
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            if (this.cookiePrefs.contains(COOKIE_NAME_PREFIX + name)) {
                prefsWriter.remove(COOKIE_NAME_PREFIX + name);
            }
            prefsWriter.putString(uri.getHost(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(uri.getHost()).keySet()));
            prefsWriter.commit();
            return true;
        }
        return false;
    }

    @Override
    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> ret = new ArrayList<HttpCookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    @Override
    public List<URI> getURIs() {
        ArrayList<URI> ret = new ArrayList<URI>();
        for (String key : this.cookies.keySet()) {
            try {
                ret.add(new URI(key));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected String encodeCookie(SerializableHttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in encodeCookie", (Throwable)e);
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    protected HttpCookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        HttpCookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableHttpCookie)objectInputStream.readObject()).getCookie();
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"IOException in decodeCookie", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Log.d((String)LOG_TAG, (String)"ClassNotFoundException in decodeCookie", (Throwable)e);
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

