/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.cookie;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public final class SimpleCookieJar
implements CookieJar {
    private final Set<Cookie> allCookies = new HashSet<Cookie>();

    public synchronized void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        ArrayList<Cookie> copy = new ArrayList<Cookie>(this.allCookies);
        this.allCookies.addAll(cookies);
        ArrayList<Cookie> needRemove = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            for (Cookie old : copy) {
                if (!old.name().equals(cookie.name())) continue;
                needRemove.add(old);
            }
        }
        this.allCookies.removeAll(needRemove);
    }

    public synchronized List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (Cookie cookie : this.allCookies) {
            if (!cookie.matches(url)) continue;
            result.add(cookie);
        }
        return result;
    }
}

