/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Pair;
import com.sobot.network.http.db.SobotDBHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;

public abstract class SobotBaseDao<T> {
    private static final boolean isDebug = false;
    protected static String TAG;
    protected Lock lock;
    protected SQLiteOpenHelper helper;
    protected SQLiteDatabase database;

    public SobotBaseDao(SQLiteOpenHelper helper) {
        TAG = this.getClass().getSimpleName();
        this.lock = SobotDBHelper.lock;
        this.helper = helper;
        this.database = this.openWriter();
    }

    public SQLiteDatabase openWriter() {
        try {
            return this.helper.getWritableDatabase();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final void closeDatabase(SQLiteDatabase database, Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        if (database != null && database.isOpen()) {
            database.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(T t) {
        if (t == null) {
            return false;
        }
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            this.database.insert(this.getTableName(), null, this.getContentValues(t));
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public long insert(SQLiteDatabase database, T t) {
        return database.insert(this.getTableName(), null, this.getContentValues(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(List<T> ts) {
        if (ts == null) {
            return false;
        }
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            for (T t : ts) {
                this.database.insert(this.getTableName(), null, this.getContentValues(t));
            }
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public boolean insert(SQLiteDatabase database, List<T> ts) {
        try {
            for (T t : ts) {
                database.insert(this.getTableName(), null, this.getContentValues(t));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteAll() {
        return this.delete(null, null);
    }

    public long deleteAll(SQLiteDatabase database) {
        return this.delete(database, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String whereClause, String[] whereArgs) {
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            this.database.delete(this.getTableName(), whereClause, whereArgs);
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public long delete(SQLiteDatabase database, String whereClause, String[] whereArgs) {
        return database.delete(this.getTableName(), whereClause, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteList(List<Pair<String, String[]>> where) {
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            for (Pair<String, String[]> pair : where) {
                this.database.delete(this.getTableName(), (String)pair.first, (String[])pair.second);
            }
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(T t) {
        if (t == null) {
            return false;
        }
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            this.database.replace(this.getTableName(), null, this.getContentValues(t));
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public long replace(SQLiteDatabase database, T t) {
        return database.replace(this.getTableName(), null, this.getContentValues(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(ContentValues contentValues) {
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            this.database.replace(this.getTableName(), null, contentValues);
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public long replace(SQLiteDatabase database, ContentValues contentValues) {
        return database.replace(this.getTableName(), null, contentValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(List<T> ts) {
        if (ts == null) {
            return false;
        }
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            for (T t : ts) {
                this.database.replace(this.getTableName(), null, this.getContentValues(t));
            }
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public boolean replace(SQLiteDatabase database, List<T> ts) {
        try {
            for (T t : ts) {
                database.replace(this.getTableName(), null, this.getContentValues(t));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(T t, String whereClause, String[] whereArgs) {
        if (t == null) {
            return false;
        }
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            this.database.update(this.getTableName(), this.getContentValues(t), whereClause, whereArgs);
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public long update(SQLiteDatabase database, T t, String whereClause, String[] whereArgs) {
        return database.update(this.getTableName(), this.getContentValues(t), whereClause, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ContentValues contentValues, String whereClause, String[] whereArgs) {
        if (this.database == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        try {
            this.database.beginTransaction();
            this.database.update(this.getTableName(), contentValues, whereClause, whereArgs);
            this.database.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
        return false;
    }

    public long update(SQLiteDatabase database, ContentValues contentValues, String whereClause, String[] whereArgs) {
        return database.update(this.getTableName(), contentValues, whereClause, whereArgs);
    }

    public List<T> queryAll(SQLiteDatabase database) {
        return this.query(database, null, null);
    }

    public List<T> query(SQLiteDatabase database, String selection, String[] selectionArgs) {
        return this.query(database, null, selection, selectionArgs, null, null, null, null);
    }

    public T queryOne(SQLiteDatabase database, String selection, String[] selectionArgs) {
        List<T> query = this.query(database, null, selection, selectionArgs, null, null, null, "1");
        if (query.size() > 0) {
            return query.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> query(SQLiteDatabase database, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        ArrayList<T> list = new ArrayList<T>();
        Cursor cursor = null;
        try {
            cursor = database.query(this.getTableName(), columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            while (!cursor.isClosed() && cursor.moveToNext()) {
                list.add(this.parseCursorToBean(cursor));
            }
            this.closeDatabase(null, cursor);
            return list;
        }
        catch (Exception exception) {
            return list;
        }
        finally {
            this.closeDatabase(null, cursor);
        }
    }

    public List<T> queryAll() {
        return this.query(null, null);
    }

    public List<T> query(String selection, String[] selectionArgs) {
        return this.query(null, selection, selectionArgs, null, null, null, null);
    }

    public T queryOne(String selection, String[] selectionArgs) {
        long start = System.currentTimeMillis();
        List<T> query = this.query(null, selection, selectionArgs, null, null, null, "1");
        return query.size() > 0 ? (T)query.get(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<T> query(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        if (this.database == null) {
            return new ArrayList();
        }
        long start = System.currentTimeMillis();
        this.lock.lock();
        ArrayList<T> list = new ArrayList<T>();
        Cursor cursor = null;
        try {
            this.database.beginTransaction();
            cursor = this.database.query(this.getTableName(), columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            while (!cursor.isClosed() && cursor.moveToNext()) {
                list.add(this.parseCursorToBean(cursor));
            }
            this.database.setTransactionSuccessful();
            this.closeDatabase(null, cursor);
        }
        catch (Exception exception) {
            this.closeDatabase(null, cursor);
            this.database.endTransaction();
            this.lock.unlock();
            catch (Throwable throwable) {
                this.closeDatabase(null, cursor);
                this.database.endTransaction();
                this.lock.unlock();
                throw throwable;
            }
        }
        this.database.endTransaction();
        this.lock.unlock();
        return list;
    }

    public void startTransaction(Action action) {
        if (this.database == null) {
            return;
        }
        this.lock.lock();
        try {
            this.database.beginTransaction();
            action.call(this.database);
            this.database.setTransactionSuccessful();
        }
        catch (Exception exception) {
        }
        finally {
            this.database.endTransaction();
            this.lock.unlock();
        }
    }

    public abstract String getTableName();

    public abstract void unInit();

    public abstract T parseCursorToBean(Cursor var1);

    public abstract ContentValues getContentValues(T var1);

    public static interface Action {
        public void call(SQLiteDatabase var1);
    }
}

