/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.sobot.network.apiUtils.SobotHttpGlobalContext;
import com.sobot.network.http.db.StColumnEntity;
import com.sobot.network.http.db.StTableEntity;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class SobotDBHelper
extends SQLiteOpenHelper {
    private static final String DB_CACHE_NAME = "sobot.db";
    private static final int DB_CACHE_VERSION = 1;
    static final String TABLE_FILECACHE = "fileCache";
    static final Lock lock = new ReentrantLock();
    private StTableEntity fileCacheTableEntity = new StTableEntity("fileCache");

    SobotDBHelper() {
        this(SobotHttpGlobalContext.getAppContext());
    }

    SobotDBHelper(Context context) {
        super(context, DB_CACHE_NAME, null, 1);
        this.fileCacheTableEntity.addColumn(new StColumnEntity("tag", "VARCHAR", true, true)).addColumn(new StColumnEntity("url", "VARCHAR")).addColumn(new StColumnEntity("isUpload", "INTEGER")).addColumn(new StColumnEntity("folder", "VARCHAR")).addColumn(new StColumnEntity("filePath", "VARCHAR")).addColumn(new StColumnEntity("fileName", "VARCHAR")).addColumn(new StColumnEntity("fraction", "VARCHAR")).addColumn(new StColumnEntity("totalSize", "INTEGER")).addColumn(new StColumnEntity("currentSize", "INTEGER")).addColumn(new StColumnEntity("status", "INTEGER")).addColumn(new StColumnEntity("priority", "INTEGER")).addColumn(new StColumnEntity("date", "INTEGER"));
    }

    public void onCreate(SQLiteDatabase db) {
        this.onFirstCreate(db);
        boolean FIRST_DATABASE_VERSION = true;
        this.onUpgrade(db, 1, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.beginTransaction();
        try {
            while (oldVersion < newVersion) {
                this.upgradeDB(db, oldVersion, newVersion);
                ++oldVersion;
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
    }

    private void onFirstCreate(SQLiteDatabase db) {
        db.execSQL(this.fileCacheTableEntity.buildTableString());
    }

    private void upgradeDB(SQLiteDatabase db, int oldVersion, int newVersion) {
        switch (oldVersion) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }
}

