/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.download;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.sobot.network.apiUtils.SobotHttpGlobalContext;
import com.sobot.network.http.db.SobotDownloadManager;
import com.sobot.network.http.download.SobotDownloadTask;
import com.sobot.network.http.download.SobotDownloadThreadPool;
import com.sobot.network.http.log.SobotNetLogUtils;
import com.sobot.network.http.model.SobotProgress;
import com.sobot.network.http.request.RequestCall;
import com.sobot.network.http.task.XExecutor;
import com.sobot.network.http.utils.IOUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SobotDownload {
    private static SobotDownload instance;
    private String folder = SobotDownload.getSDCardRootPath(SobotHttpGlobalContext.getAppContext()) + "download" + File.separator;
    private SobotDownloadThreadPool threadPool;
    private ConcurrentHashMap<String, SobotDownloadTask> taskMap;
    private static final String ROOT_DIR = "sobot";
    private static final String CACHE_DIR = "cache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SobotDownload getInstance() {
        if (instance != null) return instance;
        Class<SobotDownload> clazz = SobotDownload.class;
        synchronized (SobotDownload.class) {
            if (instance != null) return instance;
            instance = new SobotDownload();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SobotDownload() {
        IOUtils.createFolder(this.folder);
        this.threadPool = new SobotDownloadThreadPool();
        this.taskMap = new ConcurrentHashMap();
        SobotDownloadManager.getInstance().updateDownloading2None();
    }

    public static SobotDownloadTask request(String tag, RequestCall request) {
        Map<String, SobotDownloadTask> taskMap = SobotDownload.getInstance().getTaskMap();
        SobotDownloadTask task = taskMap.get(tag);
        if (task == null) {
            task = new SobotDownloadTask(tag, request);
            taskMap.put(tag, task);
        }
        return task;
    }

    public static SobotDownloadTask restore(SobotProgress progress) {
        Map<String, SobotDownloadTask> taskMap = SobotDownload.getInstance().getTaskMap();
        SobotDownloadTask task = taskMap.get(progress.tag);
        if (task == null) {
            task = new SobotDownloadTask(progress);
            taskMap.put(progress.tag, task);
        }
        return task;
    }

    public static List<SobotDownloadTask> restore(List<SobotProgress> progressList) {
        Map<String, SobotDownloadTask> taskMap = SobotDownload.getInstance().getTaskMap();
        ArrayList<SobotDownloadTask> tasks = new ArrayList<SobotDownloadTask>();
        for (SobotProgress progress : progressList) {
            SobotDownloadTask task = taskMap.get(progress.tag);
            if (task == null) {
                task = new SobotDownloadTask(progress);
                taskMap.put(progress.tag, task);
            }
            tasks.add(task);
        }
        return tasks;
    }

    public void startAll() {
        for (Map.Entry<String, SobotDownloadTask> entry : this.taskMap.entrySet()) {
            SobotDownloadTask task = entry.getValue();
            if (task == null) continue;
            task.start();
        }
    }

    public void pauseAll() {
        SobotDownloadTask task;
        for (Map.Entry<String, SobotDownloadTask> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null || task.progress.status == 2) continue;
            task.pause();
        }
        for (Map.Entry<String, SobotDownloadTask> entry : this.taskMap.entrySet()) {
            task = entry.getValue();
            if (task == null || task.progress.status != 2) continue;
            task.pause();
        }
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public void removeAll(boolean isDeleteFile) {
        SobotDownloadTask task;
        HashMap<String, SobotDownloadTask> map = new HashMap<String, SobotDownloadTask>(this.taskMap);
        for (Map.Entry entry : map.entrySet()) {
            task = (SobotDownloadTask)entry.getValue();
            if (task == null || task.progress.status == 2) continue;
            task.remove(isDeleteFile);
        }
        for (Map.Entry entry : map.entrySet()) {
            task = (SobotDownloadTask)entry.getValue();
            if (task == null || task.progress.status != 2) continue;
            task.remove(isDeleteFile);
        }
    }

    public String getFolder() {
        return this.folder;
    }

    public SobotDownload setFolder(String folder) {
        this.folder = folder;
        return this;
    }

    public void initFolder(String tmpStr) {
        this.setFolder(Environment.getExternalStorageDirectory() + File.separator + "download" + File.separator + tmpStr + File.separator);
    }

    public SobotDownloadThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Map<String, SobotDownloadTask> getTaskMap() {
        return this.taskMap;
    }

    public SobotDownloadTask getTask(String tag) {
        return this.taskMap.get(tag);
    }

    public boolean hasTask(String tag) {
        return this.taskMap.containsKey(tag);
    }

    public SobotDownloadTask removeTask(String tag) {
        return this.taskMap.remove(tag);
    }

    public void addOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().addOnAllTaskEndListener(listener);
    }

    public void removeOnAllTaskEndListener(XExecutor.OnAllTaskEndListener listener) {
        this.threadPool.getExecutor().removeOnAllTaskEndListener(listener);
    }

    public void unRegister(String tag) {
        Map<String, SobotDownloadTask> taskMap = SobotDownload.getInstance().getTaskMap();
        for (SobotDownloadTask task : this.taskMap.values()) {
            task.unRegister(tag);
        }
    }

    public static String getRootDir(Context mContext) {
        String packageName = mContext != null ? mContext.getPackageName() : "";
        String mRootPath = Environment.getExternalStorageDirectory().getPath() + File.separator + ROOT_DIR + File.separator + SobotDownload.encode(packageName + File.separator + CACHE_DIR);
        return mRootPath;
    }

    public static String getSDCardRootPath(Context context) {
        String path;
        if (context == null) {
            SobotNetLogUtils.i("context\u4e3a\u7a7a\uff1aSobotHttpUtils init \u6ca1\u6709\u521d\u59cb\u5316");
            return "";
        }
        if (SobotDownload.isExitsSdcard()) {
            path = Build.VERSION.SDK_INT < 29 ? SobotDownload.getRootDir(context) + File.separator : context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS).getPath() + File.separator + CACHE_DIR + File.separator;
            SobotNetLogUtils.i("SD\u5361\u5df2\u88c5\u5165 \u5b58\u50a8\u8def\u5f84\uff1a" + path);
        } else {
            path = context.getFilesDir().getPath() + File.separator + ROOT_DIR;
            SobotNetLogUtils.i("\u5916\u90e8\u5b58\u50a8\u4e0d\u53ef\u7528 \u5b58\u50a8\u8def\u5f84\uff1a" + path);
        }
        return path;
    }

    public static boolean isExitsSdcard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String encode(String url) {
        if (url != null) {
            Matcher matcher = Pattern.compile("[\\u4e00-\\u9fa5]").matcher(url);
            while (matcher.find()) {
                String tmp = matcher.group();
                try {
                    url = url.replaceAll(tmp, URLEncoder.encode(tmp, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return url;
    }

    public static interface CancelTagType {
        public static final String SOBOT_TAG_CHATROOM = "tag_chatroom";
        public static final String SOBOT_TAG_DOWNLOAD_ACT = "tag_download_act";
    }
}

