/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.download;

import android.content.ContentValues;
import android.text.TextUtils;
import android.util.Log;
import com.sobot.network.http.SobotOkHttpUtils;
import com.sobot.network.http.db.SobotDownloadManager;
import com.sobot.network.http.download.SobotDownload;
import com.sobot.network.http.download.SobotDownloadListener;
import com.sobot.network.http.exception.StException;
import com.sobot.network.http.exception.StHttpException;
import com.sobot.network.http.exception.StStorageException;
import com.sobot.network.http.model.SobotProgress;
import com.sobot.network.http.request.RequestCall;
import com.sobot.network.http.task.PriorityRunnable;
import com.sobot.network.http.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SobotDownloadTask
implements Runnable {
    private static final int BUFFER_SIZE = 8192;
    public SobotProgress progress;
    public Map<Object, SobotDownloadListener> listeners;
    private ThreadPoolExecutor executor;
    private PriorityRunnable priorityRunnable;

    public SobotDownloadTask(String tag, RequestCall request) {
        this.progress = new SobotProgress();
        this.progress.tag = tag;
        this.progress.isUpload = false;
        this.progress.folder = SobotDownload.getInstance().getFolder();
        this.progress.url = request.getOkHttpRequest().getBaseUrl();
        this.progress.status = 0;
        this.progress.totalSize = -1L;
        this.progress.request = request;
        this.executor = SobotDownload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, SobotDownloadListener>();
    }

    public SobotDownloadTask(SobotProgress progress) {
        this.progress = progress;
        this.executor = SobotDownload.getInstance().getThreadPool().getExecutor();
        this.listeners = new HashMap<Object, SobotDownloadListener>();
    }

    public SobotDownloadTask folder(String folder) {
        if (folder != null && !TextUtils.isEmpty((CharSequence)folder.trim())) {
            this.progress.folder = folder;
        }
        return this;
    }

    public SobotDownloadTask fileName(String fileName) {
        if (fileName != null && !TextUtils.isEmpty((CharSequence)fileName.trim())) {
            this.progress.fileName = fileName;
        }
        return this;
    }

    public SobotDownloadTask priority(int priority) {
        this.progress.priority = priority;
        return this;
    }

    public SobotDownloadTask save() {
        if (!TextUtils.isEmpty((CharSequence)this.progress.folder) && !TextUtils.isEmpty((CharSequence)this.progress.fileName)) {
            this.progress.filePath = new File(this.progress.folder, this.progress.fileName).getAbsolutePath();
        }
        SobotDownloadManager.getInstance().replace(this.progress);
        return this;
    }

    public SobotDownloadTask register(SobotDownloadListener listener) {
        if (listener != null) {
            this.listeners.put(listener.tag, listener);
        }
        return this;
    }

    public void unRegister(SobotDownloadListener listener) {
        this.listeners.remove(listener.tag);
    }

    public void unRegister(String tag) {
        this.listeners.remove(tag);
    }

    public void start() {
        if (SobotDownload.getInstance().getTask(this.progress.tag) == null || SobotDownloadManager.getInstance().get(this.progress.tag) == null) {
            Log.i((String)"SobotDownloadTask", (String)"you must call SobotDownloadTask#save() before SobotDownloadTask#start()\uff01");
            return;
        }
        if (this.progress.status == 0 || this.progress.status == 3 || this.progress.status == 4) {
            this.postOnStart(this.progress);
            this.postWaiting(this.progress);
            this.priorityRunnable = new PriorityRunnable(this.progress.priority, this);
            this.executor.execute(this.priorityRunnable);
        } else if (this.progress.status == 5) {
            if (this.progress.filePath == null) {
                this.postOnError(this.progress, new StStorageException("the file of the task with tag:" + this.progress.tag + " may be invalid or damaged, please call the method restart() to download again\uff01"));
            } else {
                File file = new File(this.progress.filePath);
                if (file.exists() && file.length() == this.progress.totalSize) {
                    this.postOnFinish(this.progress, new File(this.progress.filePath));
                } else {
                    this.postOnError(this.progress, new StStorageException("the file " + this.progress.filePath + " may be invalid or damaged, please call the method restart() to download again\uff01"));
                }
            }
        }
    }

    public void restart() {
        this.pause();
        IOUtils.delFileOrFolder(this.progress.filePath);
        this.progress.status = 0;
        this.progress.currentSize = 0L;
        this.progress.fraction = 0.0f;
        this.progress.speed = 0L;
        SobotDownloadManager.getInstance().replace(this.progress);
        this.start();
    }

    public void pause() {
        this.executor.remove(this.priorityRunnable);
        if (this.progress.status == 1) {
            this.postPause(this.progress);
        } else if (this.progress.status == 2) {
            this.progress.speed = 0L;
            this.progress.status = 3;
        }
    }

    public void remove() {
        this.remove(false);
    }

    public SobotDownloadTask remove(boolean isDeleteFile) {
        this.pause();
        if (isDeleteFile) {
            IOUtils.delFileOrFolder(this.progress.filePath);
        }
        SobotDownloadManager.getInstance().delete(this.progress.tag);
        SobotDownloadTask task = SobotDownload.getInstance().removeTask(this.progress.tag);
        this.postOnRemove(this.progress);
        return task;
    }

    @Override
    public void run() {
        RandomAccessFile randomAccessFile;
        File file;
        String fileName;
        Response response;
        File file2;
        long startPosition = this.progress.currentSize;
        if (startPosition < 0L) {
            this.postOnError(this.progress, StException.BREAKPOINT_EXPIRED());
            return;
        }
        if (startPosition > 0L && !TextUtils.isEmpty((CharSequence)this.progress.filePath) && !(file2 = new File(this.progress.filePath)).exists()) {
            startPosition = 0L;
            this.progress.currentSize = 0L;
        }
        try {
            RequestCall request = this.progress.request;
            request.getOkHttpRequest().addHeader("Range", "bytes=" + startPosition + "-");
            response = request.execute();
        }
        catch (Exception e) {
            this.postOnError(this.progress, e);
            return;
        }
        int code = response.code();
        if (code == 404 || code >= 500) {
            this.postOnError(this.progress, StHttpException.NET_ERROR());
            return;
        }
        ResponseBody body = response.body();
        if (body == null) {
            this.postOnError(this.progress, new StHttpException("response body is null"));
            return;
        }
        if (this.progress.totalSize == -1L) {
            this.progress.totalSize = body.contentLength();
        }
        if (TextUtils.isEmpty((CharSequence)(fileName = this.progress.fileName))) {
            this.progress.fileName = fileName = IOUtils.getNetFileName(response, this.progress.url);
        }
        if (!IOUtils.createFolder(this.progress.folder)) {
            this.postOnError(this.progress, StStorageException.NOT_AVAILABLE());
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.progress.filePath)) {
            file = new File(this.progress.folder, fileName);
            this.progress.filePath = file.getAbsolutePath();
        } else {
            file = new File(this.progress.filePath);
        }
        if (startPosition > 0L && !file.exists()) {
            this.remove();
            this.postOnError(this.progress, StException.BREAKPOINT_EXPIRED());
            return;
        }
        if (startPosition > this.progress.totalSize) {
            this.remove(true);
            this.postOnError(this.progress, StException.BREAKPOINT_EXPIRED());
            return;
        }
        if (startPosition == 0L && file.exists()) {
            IOUtils.delFileOrFolder(file);
        }
        if (startPosition == this.progress.totalSize && startPosition > 0L) {
            if (file.exists() && startPosition == file.length()) {
                this.postOnFinish(this.progress, file);
                return;
            }
            this.remove(true);
            this.postOnError(this.progress, StException.BREAKPOINT_EXPIRED());
            return;
        }
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(startPosition);
            this.progress.currentSize = startPosition;
        }
        catch (Exception e) {
            this.postOnError(this.progress, e);
            return;
        }
        try {
            SobotDownloadManager.getInstance().replace(this.progress);
            this.download(body.byteStream(), randomAccessFile, this.progress);
        }
        catch (Exception e) {
            this.postOnError(this.progress, e);
            return;
        }
        if (this.progress.status == 3) {
            this.postPause(this.progress);
        } else if (this.progress.status == 2) {
            if (file.length() == this.progress.totalSize) {
                this.postOnFinish(this.progress, file);
            } else {
                this.postOnError(this.progress, StException.BREAKPOINT_EXPIRED());
            }
        } else {
            this.postOnError(this.progress, StException.UNKNOWN());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(InputStream input, RandomAccessFile out, SobotProgress progress) throws IOException {
        if (input == null || out == null) {
            return;
        }
        progress.status = 2;
        byte[] buffer = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(input, 8192);
        try {
            int len;
            while ((len = in.read(buffer, 0, 8192)) != -1 && progress.status == 2) {
                out.write(buffer, 0, len);
                SobotProgress.changeProgress(progress, len, progress.totalSize, new SobotProgress.Action(){

                    @Override
                    public void call(SobotProgress progress) {
                        SobotDownloadTask.this.postLoading(progress);
                    }
                });
            }
        }
        finally {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(input);
        }
    }

    private void postOnStart(final SobotProgress progress) {
        progress.speed = 0L;
        progress.status = 0;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onStart(progress);
                }
            }
        });
    }

    private void postWaiting(final SobotProgress progress) {
        progress.speed = 0L;
        progress.status = 1;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postPause(final SobotProgress progress) {
        progress.speed = 0L;
        progress.status = 3;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postLoading(final SobotProgress progress) {
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                }
            }
        });
    }

    private void postOnError(final SobotProgress progress, Throwable throwable) {
        progress.speed = 0L;
        progress.status = 4;
        progress.exception = throwable;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onError(progress);
                }
            }
        });
    }

    private void postOnFinish(final SobotProgress progress, final File file) {
        progress.speed = 0L;
        progress.fraction = 1.0f;
        progress.status = 5;
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onProgress(progress);
                    listener.onFinish(file, progress);
                }
                SobotDownload.getInstance().removeTask(progress.tag);
            }
        });
    }

    private void postOnRemove(final SobotProgress progress) {
        this.updateDatabase(progress);
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (SobotDownloadListener listener : SobotDownloadTask.this.listeners.values()) {
                    listener.onRemove(progress);
                }
                SobotDownloadTask.this.listeners.clear();
            }
        });
    }

    private void updateDatabase(SobotProgress progress) {
        ContentValues contentValues = SobotProgress.buildUpdateContentValues(progress);
        SobotDownloadManager.getInstance().update(contentValues, progress.tag);
    }
}

