/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.log;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class LoggerInterceptor
implements Interceptor {
    public static final String TAG = "OkHttpUtils";
    private String tag;
    private boolean showResponse;

    public LoggerInterceptor(String tag, boolean showResponse) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = TAG;
        }
        this.showResponse = showResponse;
        this.tag = tag;
    }

    public LoggerInterceptor(String tag) {
        this(tag, false);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.logForRequest(request);
        Response response = chain.proceed(request);
        return this.logForResponse(response);
    }

    private Response logForResponse(Response response) {
        try {
            MediaType mediaType;
            ResponseBody body;
            Log.e((String)this.tag, (String)"========response'log=======");
            Response.Builder builder = response.newBuilder();
            Response clone = builder.build();
            Log.e((String)this.tag, (String)("url : " + clone.request().url()));
            Log.e((String)this.tag, (String)("code : " + clone.code()));
            Log.e((String)this.tag, (String)("protocol : " + clone.protocol()));
            if (!TextUtils.isEmpty((CharSequence)clone.message())) {
                Log.e((String)this.tag, (String)("message : " + clone.message()));
            }
            if (this.showResponse && (body = clone.body()) != null && (mediaType = body.contentType()) != null) {
                Log.e((String)this.tag, (String)("responseBody's contentType : " + mediaType.toString()));
                if (this.isText(mediaType)) {
                    String resp = body.string();
                    Log.e((String)this.tag, (String)("responseBody's content : " + resp));
                    body = ResponseBody.create((MediaType)mediaType, (String)resp);
                    return response.newBuilder().body(body).build();
                }
                Log.e((String)this.tag, (String)"responseBody's content :  maybe [file part] , too large too print , ignored!");
            }
            Log.e((String)this.tag, (String)"========response'log=======end");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    private void logForRequest(Request request) {
        try {
            MediaType mediaType;
            RequestBody requestBody;
            String url = request.url().toString();
            Headers headers = request.headers();
            Log.e((String)this.tag, (String)"========request'log=======");
            Log.e((String)this.tag, (String)("method : " + request.method()));
            Log.e((String)this.tag, (String)("url : " + url));
            if (headers != null && headers.size() > 0) {
                Log.e((String)this.tag, (String)("headers : " + headers.toString()));
            }
            if ((requestBody = request.body()) != null && (mediaType = requestBody.contentType()) != null) {
                Log.e((String)this.tag, (String)("requestBody's contentType : " + mediaType.toString()));
                if (this.isText(mediaType)) {
                    Log.e((String)this.tag, (String)("requestBody's content : " + this.bodyToString(request)));
                } else {
                    Log.e((String)this.tag, (String)"requestBody's content :  maybe [file part] , too large too print , ignored!");
                }
            }
            Log.e((String)this.tag, (String)"========request'log=======end");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isText(MediaType mediaType) {
        if (mediaType.type() != null && mediaType.type().equals("text")) {
            return true;
        }
        return mediaType.subtype() != null && (mediaType.subtype().equals("json") || mediaType.subtype().equals("xml") || mediaType.subtype().equals("html") || mediaType.subtype().equals("webviewhtml"));
    }

    private String bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "something error when show requestBody.";
        }
    }
}

