/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.log;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SobotNetLogUtils {
    public static boolean isDebug = false;
    public static boolean allowD = false;
    public static boolean allowE = false;
    public static boolean allowI = false;
    public static boolean allowV = false;
    public static boolean allowW = false;
    public static boolean allowWtf = false;
    private static final int MAX_LENGTH = 3072;

    private SobotNetLogUtils() {
    }

    public static void setShowDebug(Boolean isShowLog) {
        if (isShowLog.booleanValue()) {
            isDebug = true;
            allowI = true;
            allowE = true;
            allowD = true;
        } else {
            isDebug = false;
            allowI = false;
            allowE = false;
            allowD = true;
        }
    }

    public static String generateTag() {
        return "sobot_log";
    }

    private static String getCurrentTime(String format) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String currentTime = dateFormat.format(date);
        return currentTime;
    }

    public static void d(String content) {
        if (isDebug && allowD) {
            String tag = SobotNetLogUtils.generateTag();
            Log.d((String)tag, (String)content);
        }
    }

    public static void d(String content, Throwable tr) {
        if (isDebug && allowD) {
            String tag = SobotNetLogUtils.generateTag();
            Log.d((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void e(String content) {
        if (isDebug && allowE) {
            String tag = SobotNetLogUtils.generateTag();
            Log.e((String)tag, (String)content);
        }
    }

    public static void e(String content, Throwable tr) {
        if (isDebug && allowE) {
            String tag = SobotNetLogUtils.generateTag();
            Log.e((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void i(String content) {
        if (isDebug && allowI) {
            String tag = SobotNetLogUtils.generateTag();
            if (content.length() > 3072) {
                String part = content.substring(0, 3072);
                Log.i((String)(tag + "\u5206\u6bb5\u6253\u5370\u5f00\u59cb"), (String)part);
                part = content.substring(3072, content.length());
                if (content.length() - 3072 > 3072) {
                    SobotNetLogUtils.i(part);
                } else {
                    Log.i((String)(tag + "\u5206\u6bb5\u6253\u5370\u7ed3\u675f"), (String)part);
                }
            } else {
                Log.i((String)tag, (String)content);
            }
        }
    }

    public static void i(String content, Throwable tr) {
        if (isDebug && allowI) {
            String tag = SobotNetLogUtils.generateTag();
            Log.i((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void v(String content) {
        if (isDebug && allowV) {
            String tag = SobotNetLogUtils.generateTag();
            Log.v((String)tag, (String)content);
        }
    }

    public static void v(String content, Throwable tr) {
        if (isDebug && allowV) {
            String tag = SobotNetLogUtils.generateTag();
            Log.v((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void w(String content) {
        if (isDebug && allowW) {
            String tag = SobotNetLogUtils.generateTag();
            Log.w((String)tag, (String)content);
        }
    }

    public static void w(String content, Throwable tr) {
        if (isDebug && allowW) {
            String tag = SobotNetLogUtils.generateTag();
            Log.w((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void w(Throwable tr) {
        if (isDebug && allowW) {
            String tag = SobotNetLogUtils.generateTag();
            Log.w((String)tag, (Throwable)tr);
        }
    }

    public static void wtf(String content) {
        if (isDebug && allowWtf) {
            String tag = SobotNetLogUtils.generateTag();
            Log.wtf((String)tag, (String)content);
        }
    }

    public static void wtf(String content, Throwable tr) {
        if (isDebug && allowWtf) {
            String tag = SobotNetLogUtils.generateTag();
            Log.wtf((String)tag, (String)content, (Throwable)tr);
        }
    }

    public static void wtf(Throwable tr) {
        if (isDebug && allowWtf) {
            String tag = SobotNetLogUtils.generateTag();
            Log.wtf((String)tag, (Throwable)tr);
        }
    }
}

