/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.SystemClock;
import com.sobot.network.http.request.RequestCall;
import java.io.Serializable;

public class SobotProgress
implements Serializable {
    private static final long serialVersionUID = 6353658567594109891L;
    private static final long REFRESH_TIME = 300L;
    public static final int NONE = 0;
    public static final int WAITING = 1;
    public static final int LOADING = 2;
    public static final int PAUSE = 3;
    public static final int ERROR = 4;
    public static final int FINISH = 5;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final String TAG = "tag";
    public static final String IS_UPLOAD = "isUpload";
    public static final String URL = "url";
    public static final String FOLDER = "folder";
    public static final String FILE_PATH = "filePath";
    public static final String FILE_NAME = "fileName";
    public static final String FRACTION = "fraction";
    public static final String TOTAL_SIZE = "totalSize";
    public static final String CURRENT_SIZE = "currentSize";
    public static final String STATUS = "status";
    public static final String PRIORITY = "priority";
    public static final String DATE = "date";
    public static final String REQUEST = "request";
    public String tag;
    public String tmpTag;
    public boolean isUpload;
    public String url;
    public String folder;
    public String filePath;
    public String fileName;
    public float fraction;
    public long totalSize = -1L;
    public long currentSize;
    public transient long speed;
    public int status;
    public int priority = 0;
    public long date;
    public RequestCall request;
    public Throwable exception;
    private transient long tempSize;
    private transient long lastRefreshTime = SystemClock.elapsedRealtime();

    public SobotProgress() {
        this.date = System.currentTimeMillis();
    }

    public static SobotProgress changeProgress(SobotProgress progress, long writeSize, Action action) {
        return SobotProgress.changeProgress(progress, writeSize, progress.totalSize, action);
    }

    public static SobotProgress changeProgress(SobotProgress progress, long writeSize, long totalSize, Action action) {
        boolean isNotify;
        progress.totalSize = totalSize;
        progress.currentSize += writeSize;
        progress.tempSize += writeSize;
        long currentTime = SystemClock.elapsedRealtime();
        boolean bl = isNotify = currentTime - progress.lastRefreshTime >= 300L;
        if (isNotify || progress.currentSize == totalSize) {
            long diffTime = currentTime - progress.lastRefreshTime;
            if (diffTime == 0L) {
                diffTime = 1L;
            }
            progress.fraction = (float)progress.currentSize * 1.0f / (float)totalSize;
            progress.lastRefreshTime = currentTime;
            progress.tempSize = 0L;
            if (action != null) {
                action.call(progress);
            }
        }
        return progress;
    }

    public void from(SobotProgress progress) {
        this.totalSize = progress.totalSize;
        this.currentSize = progress.currentSize;
        this.fraction = progress.fraction;
        this.speed = progress.speed;
        this.lastRefreshTime = progress.lastRefreshTime;
        this.tempSize = progress.tempSize;
    }

    public static ContentValues buildContentValues(SobotProgress progress) {
        ContentValues values = new ContentValues();
        values.put(TAG, progress.tag);
        values.put(IS_UPLOAD, Boolean.valueOf(progress.isUpload));
        values.put(URL, progress.url);
        values.put(FOLDER, progress.folder);
        values.put(FILE_PATH, progress.filePath);
        values.put(FILE_NAME, progress.fileName);
        values.put(FRACTION, Float.valueOf(progress.fraction));
        values.put(TOTAL_SIZE, Long.valueOf(progress.totalSize));
        values.put(CURRENT_SIZE, Long.valueOf(progress.currentSize));
        values.put(STATUS, Integer.valueOf(progress.status));
        values.put(PRIORITY, Integer.valueOf(progress.priority));
        values.put(DATE, Long.valueOf(progress.date));
        return values;
    }

    public static ContentValues buildUpdateContentValues(SobotProgress progress) {
        ContentValues values = new ContentValues();
        values.put(FRACTION, Float.valueOf(progress.fraction));
        values.put(TOTAL_SIZE, Long.valueOf(progress.totalSize));
        values.put(CURRENT_SIZE, Long.valueOf(progress.currentSize));
        values.put(STATUS, Integer.valueOf(progress.status));
        values.put(PRIORITY, Integer.valueOf(progress.priority));
        values.put(DATE, Long.valueOf(progress.date));
        return values;
    }

    public static SobotProgress parseCursorToBean(Cursor cursor) {
        SobotProgress progress = new SobotProgress();
        progress.tag = cursor.getString(cursor.getColumnIndex(TAG));
        progress.isUpload = 1 == cursor.getInt(cursor.getColumnIndex(IS_UPLOAD));
        progress.url = cursor.getString(cursor.getColumnIndex(URL));
        progress.folder = cursor.getString(cursor.getColumnIndex(FOLDER));
        progress.filePath = cursor.getString(cursor.getColumnIndex(FILE_PATH));
        progress.fileName = cursor.getString(cursor.getColumnIndex(FILE_NAME));
        progress.fraction = cursor.getFloat(cursor.getColumnIndex(FRACTION));
        progress.totalSize = cursor.getLong(cursor.getColumnIndex(TOTAL_SIZE));
        progress.currentSize = cursor.getLong(cursor.getColumnIndex(CURRENT_SIZE));
        progress.status = cursor.getInt(cursor.getColumnIndex(STATUS));
        progress.priority = cursor.getInt(cursor.getColumnIndex(PRIORITY));
        progress.date = cursor.getLong(cursor.getColumnIndex(DATE));
        return progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SobotProgress progress = (SobotProgress)o;
        return this.tag != null ? this.tag.equals(progress.tag) : progress.tag == null;
    }

    public int hashCode() {
        return this.tag != null ? this.tag.hashCode() : 0;
    }

    public String toString() {
        return "Progress{fraction=" + this.fraction + ", totalSize=" + this.totalSize + ", currentSize=" + this.currentSize + ", speed=" + this.speed + ", status=" + this.status + ", priority=" + this.priority + ", folder=" + this.folder + ", filePath=" + this.filePath + ", fileName=" + this.fileName + ", tag=" + this.tag + ", url=" + this.url + '}';
    }

    public static interface Action {
        public void call(SobotProgress var1);
    }
}

