/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.request;

import com.sobot.network.http.callback.Callback;
import com.sobot.network.http.request.ProgressRequestBody;
import com.sobot.network.http.request.RequestCall;
import com.sobot.network.http.utils.Exceptions;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class OkHttpRequest {
    protected String url;
    protected Object tag;
    protected Map<String, Object> params;
    protected Map<String, String> headers;
    protected Request.Builder builder = new Request.Builder();
    protected transient ProgressRequestBody.UploadInterceptor uploadInterceptor;

    protected OkHttpRequest(String url, Object tag, Map<String, Object> params, Map<String, String> headers) {
        this.url = url;
        this.tag = tag;
        this.params = params;
        this.headers = headers;
        if (url == null) {
            Exceptions.illegalArgument("url can not be null.", new Object[0]);
        }
        this.initBuilder();
    }

    private void initBuilder() {
        this.builder.url(this.url).tag(this.tag);
        this.appendHeaders();
    }

    protected abstract RequestBody buildRequestBody();

    protected RequestBody wrapRequestBody(RequestBody requestBody, Callback callback) {
        return requestBody;
    }

    protected abstract Request buildRequest(RequestBody var1);

    public RequestCall build() {
        return new RequestCall(this);
    }

    public Request generateRequest(Callback callback) {
        RequestBody requestBody = this.buildRequestBody();
        RequestBody wrappedRequestBody = this.wrapRequestBody(requestBody, callback);
        Request request = this.buildRequest(wrappedRequestBody);
        return request;
    }

    protected void appendHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (this.headers == null || this.headers.isEmpty()) {
            return;
        }
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        this.builder.headers(headerBuilder.build());
    }

    public OkHttpRequest uploadInterceptor(ProgressRequestBody.UploadInterceptor uploadInterceptor) {
        this.uploadInterceptor = uploadInterceptor;
        return this;
    }

    public String getBaseUrl() {
        return this.url;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null || this.headers.isEmpty()) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        this.appendHeaders();
    }
}

