/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.request;

import android.text.TextUtils;
import com.sobot.network.http.request.OkHttpRequest;
import com.sobot.network.http.utils.Exceptions;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class OtherRequest
extends OkHttpRequest {
    private static MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"application/json;charset=utf-8");
    private RequestBody requestBody;
    private String method;
    private String content;
    private MediaType mediaType;

    public OtherRequest(RequestBody requestBody, MediaType mediaType, String content, String method, String url, Object tag, Map<String, Object> params, Map<String, String> headers) {
        super(url, tag, params, headers);
        this.requestBody = requestBody;
        this.method = method;
        this.content = content;
        this.mediaType = mediaType;
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_PLAIN;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.requestBody == null && TextUtils.isEmpty((CharSequence)this.content) && HttpMethod.requiresRequestBody((String)this.method)) {
            Exceptions.illegalArgument("requestBody and content can not be null in method:" + this.method, new Object[0]);
        }
        if (this.requestBody == null && !TextUtils.isEmpty((CharSequence)this.content)) {
            this.requestBody = RequestBody.create((MediaType)this.mediaType, (String)this.content);
        }
        return this.requestBody;
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        if (this.method.equals("PUT")) {
            this.builder.put(requestBody);
        } else if (this.method.equals("DELETE")) {
            if (requestBody == null) {
                this.builder.delete();
            } else {
                this.builder.delete(requestBody);
            }
        } else if (this.method.equals("HEAD")) {
            this.builder.head();
        } else if (this.method.equals("PATCH")) {
            this.builder.patch(requestBody);
        }
        return this.builder.build();
    }
}

