/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.request;

import com.sobot.network.http.builder.PostMultipartFormBuilder;
import com.sobot.network.http.callback.Callback;
import com.sobot.network.http.request.OkHttpRequest;
import com.sobot.network.http.request.ProgressRequestBody;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostMultipartFormRequest
extends OkHttpRequest {
    private List<PostMultipartFormBuilder.FileInput> files;

    public PostMultipartFormRequest(String url, Object tag, Map<String, Object> params, Map<String, String> headers, List<PostMultipartFormBuilder.FileInput> files) {
        super(url, tag, params, headers);
        this.files = files;
    }

    @Override
    protected RequestBody buildRequestBody() {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        this.addParams(builder);
        for (int i = 0; i < this.files.size(); ++i) {
            PostMultipartFormBuilder.FileInput fileInput = this.files.get(i);
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)this.guessMimeType(fileInput.filename)), (File)fileInput.file);
            try {
                builder.addFormDataPart(fileInput.key, URLEncoder.encode(fileInput.filename, "UTF-8"), fileBody);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, Callback callback) {
        ProgressRequestBody progressRequestBody = new ProgressRequestBody(requestBody, callback);
        progressRequestBody.setInterceptor(this.uploadInterceptor);
        return progressRequestBody;
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = fileNameMap.getContentTypeFor(path = path.replace("#", ""));
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    private void addParams(MultipartBody.Builder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            for (String key : this.params.keySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)this.params.get(key).toString()));
            }
        }
    }

    private void addParams(FormBody.Builder builder) {
        if (this.params != null) {
            for (String key : this.params.keySet()) {
                if (this.params.get(key) == null) continue;
                builder.add(key, this.params.get(key).toString());
            }
        }
    }
}

