/*
 * Decompiled with CFR 0.152.
 */
package com.sobot.network.http.request;

import com.sobot.network.http.SobotOkHttpUtils;
import com.sobot.network.http.callback.Callback;
import com.sobot.network.http.model.SobotProgress;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressRequestBody
extends RequestBody {
    private RequestBody requestBody;
    private Callback callback;
    private UploadInterceptor interceptor;

    ProgressRequestBody(RequestBody requestBody, Callback callback) {
        this.requestBody = requestBody;
        this.callback = callback;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() {
        try {
            return this.requestBody.contentLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)countingSink);
        this.requestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private void onProgress(final SobotProgress progress) {
        SobotOkHttpUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (ProgressRequestBody.this.callback != null) {
                    ProgressRequestBody.this.callback.inProgress(progress.fraction);
                }
            }
        });
    }

    public void setInterceptor(UploadInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static interface UploadInterceptor {
        public void uploadProgress(SobotProgress var1);
    }

    private final class CountingSink
    extends ForwardingSink {
        private SobotProgress progress;

        CountingSink(Sink delegate) {
            super(delegate);
            this.progress = new SobotProgress();
            this.progress.totalSize = ProgressRequestBody.this.contentLength();
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            SobotProgress.changeProgress(this.progress, byteCount, new SobotProgress.Action(){

                @Override
                public void call(SobotProgress progress) {
                    if (ProgressRequestBody.this.interceptor != null) {
                        ProgressRequestBody.this.interceptor.uploadProgress(progress);
                    } else {
                        ProgressRequestBody.this.onProgress(progress);
                    }
                }
            });
        }
    }
}

